% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goose_survey_tools.R
\name{goose_rename_columns}
\alias{goose_rename_columns}
\title{Intelligently Rename Survey Columns}
\usage{
goose_rename_columns(
  data,
  max_length = 20,
  style = c("snake_case", "camelCase", "SCREAMING_SNAKE"),
  abbreviate = TRUE,
  save_map = TRUE,
  map_file = NULL,
  preview_only = FALSE,
  custom_dict = NULL
)
}
\arguments{
\item{data}{A data frame with columns to rename (typically survey data)}

\item{max_length}{Maximum length for new column names (default: 20)}

\item{style}{Naming style: "snake_case" (default), "camelCase", "SCREAMING_SNAKE"}

\item{abbreviate}{Logical, whether to use intelligent abbreviation (default: TRUE)}

\item{save_map}{Logical, whether to save the name mapping (default: TRUE)}

\item{map_file}{Path to save the mapping CSV file (auto-generated if NULL)}

\item{preview_only}{Logical, if TRUE only shows proposed changes without applying (default: FALSE)}

\item{custom_dict}{Named vector of custom abbreviations (e.g., c("satisfaction" = "sat"))}
}
\value{
If preview_only = FALSE: Data frame with renamed columns
If preview_only = TRUE: Data frame showing the mapping
}
\description{
Transforms long survey question text into short, meaningful variable names.
Combines janitor::clean_names() functionality with intelligent abbreviation
to create readable, consistent column names. Saves a mapping file for reference.
}
\details{
The function performs intelligent renaming by:
\enumerate{
\item Removing special characters and standardizing format (via clean_names)
\item Detecting common survey patterns (scales, demographics, etc.)
\item Creating meaningful abbreviations for long questions
\item Ensuring uniqueness of all column names
\item Saving a reference map for documentation
}

Common patterns detected:
\itemize{
\item Likert scales ("How satisfied...", "To what extent...")
\item Demographics ("What is your age", "Gender", etc.)
\item Yes/No questions
\item Multiple choice questions
\item Open-ended responses
}
}
\examples{
\dontrun{
# Basic usage - rename survey columns
survey_clean <- goose_rename_columns(survey_data)

# Preview changes first
goose_rename_columns(survey_data, preview_only = TRUE)

# Use custom abbreviations
survey_clean <- goose_rename_columns(survey_data,
  custom_dict = c(
    "satisfaction" = "sat",
    "recommendation" = "rec",
    "likelihood" = "likely"
  )
)

# Use camelCase instead of snake_case
survey_clean <- goose_rename_columns(survey_data, style = "camelCase")
}
}
