% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_read.R
\name{drive_read_string}
\alias{drive_read_string}
\alias{drive_read_raw}
\title{Read the content of a Drive file}
\usage{
drive_read_string(file, type = NULL, encoding = NULL)

drive_read_raw(file, type = NULL)
}
\arguments{
\item{file}{Something that identifies the file of interest on your Google
Drive. Can be a name or path, a file id or URL marked with \code{\link[=as_id]{as_id()}}, or a
\code{\link{dribble}}.}

\item{type}{Character. Only consulted if \code{file} is a native Google file.
Specifies the desired type of the exported file. Will be processed via
\code{\link[=drive_mime_type]{drive_mime_type()}}, so either a file extension like \code{"pdf"} or a full MIME
type like \code{"application/pdf"} is acceptable.}

\item{encoding}{Passed along to \code{\link[httr:content]{httr::content()}}. Describes the encoding of
the \emph{input} \code{file}.}
}
\value{
\itemize{
\item \code{read_drive_string()}: a UTF-8 encoded string
\item \code{read_drive_raw()}: a \code{\link[=raw]{raw()}} vector
}
}
\description{
These functions return the content of a Drive file as either a
string or raw bytes. You will likely need to do additional work to parse
the content into a useful R object.

\code{\link[=drive_download]{drive_download()}} is the more generally useful function, but for certain
file types, such as comma-separated values (MIME type \code{text/csv}), it can
be handy to read data directly from Google Drive and avoid writing to disk.

Just as for \code{\link[=drive_download]{drive_download()}}, native Google file types, such as Google
Sheets or Docs, must be exported as a conventional MIME type. See the help
for \code{\link[=drive_download]{drive_download()}} for more.
}
\examples{
\dontshow{if (drive_has_token()) withAutoprint(\{ # examplesIf}
# comma-separated values --> data.frame or tibble
(chicken_csv <- drive_example_remote("chicken.csv"))
read.csv(text = chicken_csv |> drive_read_string())

# Google Doc --> character vector
(chicken_doc <- drive_example_remote("chicken_doc"))
chicken_doc |>
  # NOTE: we must specify an export MIME type
  drive_read_string(type = "text/plain") |>
  strsplit(split = "(\r\n|\r|\n)")
  (\(x) x[[1]])()
\dontshow{\}) # examplesIf}
}
