% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_goat_manuscript_data}
\alias{download_goat_manuscript_data}
\title{Download the datasets that were used in the GOAT manuscript}
\usage{
download_goat_manuscript_data(output_dir, ignore_cache = FALSE)
}
\arguments{
\item{output_dir}{full path to the directory where the downloaded files should be stored. Directory is created if it does not exist.
e.g. \code{output_dir="~/data"} on unix systems, \code{output_dir="C:/data"} on Windows, or set to \code{output_dir=getwd()} to write output to the current working directory}

\item{ignore_cache}{boolean, set to TRUE to force re-download and ignore cached data, if any. Default: FALSE}
}
\value{
a list of genelist data tables. The names of the list represent the datasets,
values in the list are data tables that can be used as a "genelist" in the GOAT R package
}
\description{
Downloads OMICs-based datasets that were used in the GOAT manuscript from the GOAT GitHub page.
This file is cached in the output directory and only needs to be downloaded once. Multiple datasets
are included and their names include the respective PubMed identifiers (PMID).

If you encounter technical difficulties, try to;
\enumerate{
\item download the file by copy/pasting this URL into your browser: https://github.com/ftwkoopmans/goat/raw/main/analyses/goat_manuscript_datasets.rda
\item load the data in R using the following 2 lines of code, here assuming you stored the downloaded file at C:/data/goat_manuscript_datasets.rda
}

\code{load("C:/data/goat_manuscript_datasets.rda")}

\code{genelist = goat_manuscript_datasets.rda[["Wingo 2020:mass-spec:PMID32424284"]]}
}
