% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptiveTableTainan2020dataset.R
\name{descriptiveTableTainan2020dataset}
\alias{descriptiveTableTainan2020dataset}
\title{Descriptive statistic table for the tainan2020dataset}
\usage{
descriptiveTableTainan2020dataset(savePath = NULL)
}
\arguments{
\item{savePath}{Character (optional). String specifying the path and filename
for exporting the table.
\itemize{
\item If NULL (default), the table will not be exported.
\item If "" (empty string), the table will be saved in the working directory using a default name.
\item Expected format: 'filepath/filename.extensions' where:
\itemize{
\item filepath is the directory (must already exist), default is the working directory;
\item filename is the name of the file, default to 'table_tainan2020dataset_timestamp.png';
\item extension must be one of png, pdf or html and must be specified, unless using the default filename.
}
}}
}
\value{
A 'table1' object containing descriptive statistics grouped by survival status.
}
\description{
Function to create, display and optionally export a table
containing descriptive statistics for the tainan2020dataset.\cr
The table is created using the table1 package and is grouped by survival status.
}
\examples{
# Create and display the table, without saving anything
descriptiveTableTainan2020dataset()

\donttest{
# Create, display and save the table giving a path, filename and extension
descriptiveTableTainan2020dataset(savePath = "tables/tainan_web_table.html")

# Create, display and save the table giving a path, filename and extension
descriptiveTableTainan2020dataset(savePath = "tables/tainan_table.pdf")

# Create, display and save the table giving only the path, default name will be used
descriptiveTableTainan2020dataset(savePath = "tables/")

# Create, display and save the table giving a path and filename,default extension will be used
descriptiveTableTainan2020dataset(savePath = "tables/tainan_table")

}

}
\seealso{
\code{\link[table1:table1]{table1::table1()}}
}
