% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.anosim.R
\name{fortify.anosim}
\alias{fortify.anosim}
\alias{tidy.anosim}
\title{Fortify analysis of similarities (ANOSIM) results}
\usage{
\method{fortify}{anosim}(model, data, ...)

\method{tidy}{anosim}(x, data, ...)
}
\arguments{
\item{model, x}{an object of class \code{\link[vegan:anosim]{vegan::anosim()}}.}

\item{data}{original data set. Currently ignored.}

\item{...}{additional arguments for other methods. Currently ignored.}
}
\value{
A data frame with columns \code{Rank} and \code{Class} with ranks of
dissimilarity.
}
\description{
Prepares a fortified version of results from \code{\link[vegan:anosim]{vegan::anosim()}}
objects.
}
\examples{

library("vegan")

library("ggplot2")
data(dune, dune.env)
dune.dist <- vegdist(dune)
dune.ano <- with(dune.env, anosim(dune.dist, Management))

df <- fortify(dune.ano)

ggplot(df, aes(x = class, y = rank)) +
    geom_boxplot(notch = FALSE, varwidth = TRUE)

}
\author{
Original implementation by Didzis Elferts. Modification to tibbles
by Gavin L. Simpson.
}
