% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additions.R
\name{set_edges}
\alias{set_edges}
\title{Set region boundary edges}
\usage{
set_edges(p, colour = "black", width = 1)
}
\arguments{
\item{p}{A `ggseg3d` widget or `ggsegray` rgl object.}

\item{colour}{string. Edge colour (hex or named color). Set to NULL to
hide edges.}

\item{width}{numeric. Width of edge lines (default: 1). Note: line width > 1
may not render on all systems due to WebGL limitations.}
}
\value{
The input object (modified), for piping.
}
\description{
Adds coloured outlines around brain regions. This is useful for
highlighting region boundaries in figures. Works with both
htmlwidget (`ggseg3d`) and rgl (`ggsegray`) objects. For rgl,
edges must have been computed at creation time via `edge_by`.
}
\section{Lifecycle}{

`r lifecycle::badge("experimental")`
}

\examples{
\dontrun{
ggseg3d(hemisphere = "left", edge_by = "region") |>
  set_edges("black") |>
  pan_camera("left lateral")

ggsegray(hemisphere = "left", edge_by = "region") |>
  set_edges("red", width = 2) |>
  pan_camera("left lateral")
}
}
