% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_multi.R
\name{legend_split}
\alias{legend_split}
\title{Force Legends to Stay Separate}
\usage{
legend_split(...)
}
\arguments{
\item{...}{Aesthetic names (unquoted) to keep separate.
E.g., \code{colour, fill}.}
}
\value{
A guides specification that can be added to a plot.
}
\description{
Force specified legends to remain separate by assigning different order
values, preventing automatic merging.
}
\details{
By default, ggplot2 merges legends that have matching titles and labels.
This function assigns different order values to each legend, which prevents
automatic merging.
}
\examples{
library(ggplot2)

# Plot where colour and fill would normally merge
p <- ggplot(mtcars, aes(mpg, wt, color = factor(cyl), fill = factor(cyl))) +
  geom_point(shape = 21, size = 3, stroke = 1.5) +
  labs(color = "Cylinders", fill = "Cylinders")

# Force separate legends
p + legend_split(colour, fill)

}
\seealso{
\code{\link{legend_merge}}, \code{\link{legend_order_guides}}
}
