% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_base.R
\name{get_plot_extremes}
\alias{get_plot_extremes}
\title{Calculate plot extremes}
\usage{
get_plot_extremes(
  allRibbon = NULL,
  seqArcs = NULL,
  axisLines = NULL,
  axisTicks = NULL,
  gene_arrows = NULL,
  gene_polys = NULL,
  show_axis = FALSE
)
}
\arguments{
\item{allRibbon}{data.frame, ribbon data (with x, y columns), default NULL}

\item{seqArcs}{List, sequence arc data (each element is a data frame with x, y, seq_id), default NULL}

\item{axisLines}{data.frame, axis line data (with x, y, seq_id columns), default NULL}

\item{axisTicks}{data.frame, tick mark data (with x0, y0, x1, y1, label_x, label_y columns), default NULL}

\item{gene_arrows}{data.frame, gene label data (with text_x, text_y columns), default NULL}

\item{gene_polys}{data.frame, gene arrow polygon data (with x, y columns), default NULL}

\item{show_axis}{Logical, whether to include extreme value calculation for axis-related elements, default FALSE}
}
\value{
List containing x_min (minimum x), x_max (maximum x), y_min (minimum y), y_max (maximum y)
}
\description{
Extracts x/y coordinate extremes from all plot elements (sequence arcs, ribbons, gene arrows, etc.) for adjusting the plot range
}
\keyword{internal}
