% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-magick.R
\name{raster_magick}
\alias{raster_magick}
\title{Rasterize the ggplot layers}
\usage{
raster_magick(x, ...)
}
\arguments{
\item{x}{An object to rasterize, can be a \code{\link[grid:grid.grob]{grob()}},
\code{\link[ggplot2:layer]{layer()}}, \code{\link[ggplot2:ggplot]{ggplot()}}, or a list of such
objects.}

\item{...}{Additional arguments passed on to \code{\link[=magickGrob]{magickGrob()}}.}
}
\value{
An object with the same class of the input.
}
\description{
The function rasterizes input graphical objects (e.g., grob, layer, ggplot)
and optionally processes the resulting raster using magick, a powerful image
manipulation library. This allows for advanced graphical transformations
directly within the plotting pipeline.
}
\examples{
# Currently, `magick` package require R >= 4.1.0
if (requireNamespace("magick")) {
    # data generated code was copied from `ComplexHeatmap`
    set.seed(123)
    small_mat <- matrix(rnorm(56), nrow = 7)
    rownames(small_mat) <- paste0("row", seq_len(nrow(small_mat)))
    colnames(small_mat) <- paste0("column", seq_len(ncol(small_mat)))
    ggheatmap(small_mat, aes(.x, .y), filling = NULL) +
        raster_magick(geom_tile(aes(fill = value)), res = 20)

    ggheatmap(small_mat, aes(.x, .y), filling = NULL) +
        # Use `magick::filter_types()` to check available `filter` arguments
        raster_magick(
            geom_tile(aes(fill = value)),
            magick = function(image) {
                magick::image_resize(image,
                    geometry = "50\%x", filter = "Lanczos"
                )
            }
        )
}
}
\seealso{
\code{\link[=magickGrob]{magickGrob()}}
}
