% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heda.R
\name{get_heda}
\alias{get_heda}
\title{Get Harvard Election Data Archive ("HEDA") Dataset}
\usage{
get_heda(state, path = tempdir(), epsg = 3857, ...)
}
\arguments{
\item{state}{two letter state abbreviation}

\item{path}{folder to put shape in. Default is \code{tempdir()}}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}

\item{...}{additional arguments passed to \code{\link[sf:st_read]{sf::read_sf()}}}
}
\value{
sf tibble
}
\description{
Get Harvard Election Data Archive ("HEDA") Dataset
}
\examples{
\dontshow{if (Sys.getenv('DATAVERSE_KEY') != '') withAutoprint(\{ # examplesIf}
shp <- get_heda('ND')
\dontshow{\}) # examplesIf}
}
\concept{datasets}
