% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_geelite.R
\name{get_batches}
\alias{get_batches}
\title{Produce Batches for Build/Update Mixed Cases}
\usage{
get_batches(cases, grid, batch_size)
}
\arguments{
\item{cases}{[mandatory] (integer) 1=All build, 2=All update, 3=Mixed.}

\item{grid}{[mandatory] (sf) The sf object (grid) containing column 'add'
to distinguish existing vs. new rows.}

\item{batch_size}{[mandatory] (integer) If \code{cases} = 1 or 2, we'll call
\code{get_batch(grid,batch_size=batch_size)}.}
}
\value{
(list) A list of two elements, \code{b1} and \code{b2}, each a list
  of sf subsets (chunks). \code{b2} might be \code{NULL} if not needed.
}
\description{
Divides the grid into one or two lists of chunked sf objects,
depending on the data-collection case (1,2,3).
}
\keyword{internal}
