% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vsi_get_file_metadata}
\alias{vsi_get_file_metadata}
\title{Get metadata on files}
\usage{
vsi_get_file_metadata(filename, domain)
}
\arguments{
\item{filename}{Character string. The path of the file system object to be
queried.}

\item{domain}{Character string. Metadata domain to query. Depends on the
file system, see Details.}
}
\value{
A named list of values, or \code{NULL} in case of error or empty list.
}
\description{
\code{vsi_get_file_metadata()} returns metadata for file system objects.
Implemented for network-like filesystems. Starting with GDAL 3.7,
implemented for /vsizip/ with SOZip metadata.
Wrapper of \code{VSIGetFileMetadata()} in the GDAL Common Portability Library.
}
\details{
The metadata available depends on the file system. The following are
supported as of GDAL 3.9:
\itemize{
\item HEADERS: to get HTTP headers for network-like filesystems (/vsicurl/,
/vsis3/, /vsgis/, etc).
\item TAGS: for /vsis3/, to get S3 Object tagging information. For /vsiaz/,
to get blob tags.
\item STATUS: specific to /vsiadls/: returns all system-defined properties
for a path (seems in practice to be a subset of HEADERS).
\item ACL: specific to /vsiadls/ and /vsigs/: returns the access control list
for a path. For /vsigs/, a single \code{XML=xml_content} string is returned.
\item METADATA: specific to /vsiaz/: blob metadata (this will be a subset of
what \code{domain=HEADERS} returns).
\item ZIP: specific to /vsizip/: to obtain ZIP specific metadata, in
particular if a file is SOZIP-enabled (\code{SOZIP_VALID=YES}).
}
}
\examples{
\dontshow{if (gdal_version_num() >= gdal_compute_version(3, 7, 0)) withAutoprint(\{ # examplesIf}
# validate an SOZip-enabled file
# Requires GDAL >= 3.7
f <- system.file("extdata/ynp_features.zip", package = "gdalraster")

zf <- file.path("/vsizip", f)
# files in zip archive
vsi_read_dir(zf)

# SOZip metadata for ynp_features.gpkg
zf_gpkg <- file.path(zf, "ynp_features.gpkg")
vsi_get_file_metadata(zf_gpkg, domain = "ZIP")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=vsi_stat]{vsi_stat()}}, \code{\link[=addFilesInZip]{addFilesInZip()}}
}
