% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.R
\name{window_time}
\alias{window_time}
\title{Apply a moving window operation over the time dimension of a data cube}
\usage{
window_time(x, expr, ..., kernel, window)
}
\arguments{
\item{x}{source data cube}

\item{expr}{either a single string, or a vector of strings defining which reducers wlil be applied over which bands of the input cube}

\item{...}{optional additional expressions (if expr is not a vector)}

\item{kernel}{numeric vector with elements of the kernel}

\item{window}{integer vector with two elements defining the size of the window before and after a cell, the total size of the window is window[1] + 1 + window[2]}
}
\value{
proxy data cube object
}
\description{
Create a proxy data cube, which applies one ore more moving window functions to selected bands over pixel time series of a data cube.
The function can either apply a built-in aggregation function or apply a custom one-dimensional 
convolution kernel.
}
\details{
The function either applies a kernel convolution (if the \code{kernel} argument is provided) or a general reducer function 
over moving temporal windows. In the former case, the kernel convolution will be applied over all bands of the input 
cube, i.e., the output cube will have the same number of bands as the input cubes. If a kernel is given and the \code{window} argument is missing, 
the window will be symmetric to the center pixel with the size of the provided kernel. For general reducer functions, the window argument must be provided and
several expressions can be used to create multiple bands in the output cube.

Notice that expressions have a very simple format: the reducer is followed by the name of a band in parantheses. You cannot add
more complex functions or arguments.

Possible reducers include "min", "max", "sum", "prod", "count", "mean", and "median".
}
\note{
Implemented reducers will ignore any NAN values (as na.rm=TRUE does).

This function returns a proxy object, i.e., it will not start any computations besides deriving the shape of the result.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db"), quiet = TRUE) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
                          bottom=4345299, top=4744931, t0="2018-01", t1="2018-07"),
                          srs="EPSG:32618", nx = 400, dt="P1M")
L8.cube = raster_cube(L8.col, v) 
L8.nir = select_bands(L8.cube, c("B05"))
L8.nir.min = window_time(L8.nir, window = c(2,2), "min(B05)")  
L8.nir.min

L8.nir.kernel = window_time(L8.nir, kernel=c(-1,1), window=c(1,0))  
L8.nir.kernel

}
