% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce.R
\name{as.data.frame.cube}
\alias{as.data.frame.cube}
\title{Convert a data cube to a data.frame}
\usage{
\method{as.data.frame}{cube}(x, ..., complete_only = FALSE)
}
\arguments{
\item{x}{data cube object}

\item{...}{not used}

\item{complete_only}{logical; if TRUE, remove rows with one or more missing values}
}
\value{
A data.frame with bands / variables of the cube as columns and pixels as rows
}
\description{
Convert a data cube to a data.frame
}
\examples{
\donttest{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db"), quiet = TRUE) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-04", t1="2018-05"),
              srs="EPSG:32618", nx = 100, ny=100, dt="P1M")
x = select_bands(raster_cube(L8.col, v), c("B04", "B05"))
df = as.data.frame(x, complete_only = TRUE)
head(df)
}
}
