% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_all_created_funs.R
\name{get_all_created_funs}
\alias{get_all_created_funs}
\title{Get all functions created in a R file}
\usage{
get_all_created_funs(file)
}
\arguments{
\item{file}{A R file}
}
\value{
A character vector of function names
}
\description{
Get all functions created in a R file
}
\examples{
file_path <- tempfile(fileext = ".R")
cat(
  "my_fun <- function() {1}",
  "my_fun2 <- function() {2}",
  sep = "\n",
  file = file_path
)
get_all_created_funs(file_path)
}
