% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_half_away_from_zero.R
\name{round_half_away_from_zero}
\alias{round_half_away_from_zero}
\alias{round_commercially}
\title{Round Half Away From Zero}
\usage{
round_half_away_from_zero(x, digits = 0)

round_commercially(x, digits = 0)
}
\arguments{
\item{x}{A number to be rounded.}

\item{digits}{The number of digits, as in \code{\link{round}}.}
}
\value{
The rounded number.
}
\description{
Commercial rounding is done a lot, especially with invoices. There is even
standard 1333 by the German Institute for Standardization.
\code{\link{round}} rounds half to even, see \code{\link{round}}'s Details
section.

\code{round_commercially} is just a link to \code{round_half_away_from_zero}.
}
\examples{
x <- 22.5
round_half_away_from_zero(x)
round(x)
round_half_away_from_zero(-x)
round(-x)
}
\seealso{
Other statistics: 
\code{\link{column_sums}()},
\code{\link{count_groups}()},
\code{\link{powers_of_ten}},
\code{\link{relative_difference}()},
\code{\link{sloboda}()},
\code{\link{weighted_variance}()}
}
\concept{statistics}
