# use snapshot for testing

    [1] "/*\n * Copyright (c) 2023 Merck & Co., Inc., Rahway, NJ, USA and its affiliates.\n * All rights reserved.\n *\n * This file is part of the forestly program.\n *\n * forestly is free software: you can redistribute it and/or modify\n * it under the terms of the GNU General Public License as published by\n * the Free Software Foundation, either version 3 of the License, or\n * (at your option) any later version.\n *\n * This program is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n * GNU General Public License for more details.\n *\n * You should have received a copy of the GNU General Public License\n * along with this program.  If not, see <http://www.gnu.org/licenses/>.\n *\n */\n\nfunction(cell, state) {\n  const Plot = createPlotlyComponent(Plotly);\n  var x = [cell.row[\"Sepal.Length\"]];\n  var y = [1];\n  var x_lower = [0];\n  var x_upper = [0];\n  var x_range = [3.8, 8.4];\n  var y_range = [0, 2];\n  var vline = [];\n  var text = [\"\"];\n  var height = 30;\n  var width = 150;\n  var color = [\"rgba(255, 215, 0, 1)\"];\n  var color_errorbar = [\"rgba(255, 255, 255, 0)\"];\n  var color_vline = \"rgba(0, 0, 0, 0.313725490196078)\";\n  var margin = [0, 0, 0, 0, 0];\n  var x_label = \"\";\n  var showlegend = false;\n  var legend_title = \"\";\n  var legend_position = 0;\n  var legend_label = [\"\"];\n\n  return React.createElement(Plot, {\n    data: [\n      \n  {\n    \"x\": [x[0]],\n    \"y\": [y[0]],\n   \"error_x\": {\n      type: \"data\",\n      symmetric: false,\n      array: [x_upper[0] - x[0]],\n      arrayminus: [x[0] - x_lower[0]],\n      \"color\": color_errorbar[0]\n    },\n    \"text\": text[0],\n    \"hoverinfo\": \"text\",\n    \"mode\": \"markers\",\n    \"alpha_stroke\": 1,\n    \"sizes\": [10, 100],\n    \"spans\": [1, 20],\n    \"type\": \"scatter\",\n    \"name\": legend_label[0],\n    \"marker\": {\n      \"color\": [color[0]],\n      \"line\": {\n          \"color\": color[0]\n      }\n    },\n    \"line\": {\n        \"color\": color[0]\n    }\n  }\n    ],\n    \"layout\": {\n      \"height\": height,\n      \"width\": width,\n      \"margin\": {\n        \"b\": margin[0],\n        \"l\": margin[1],\n        \"t\": margin[2],\n        \"r\": margin[3],\n        \"pad\": margin[4]\n      },\n      \"xaxis\": {\n        \"domain\": [0,1],\n        \"title\": {\n          \"text\": x_label,\n          \"standoff\": 0,\n          \"font\": {\n            \"size\": 12\n          }\n        },\n        \"range\": x_range,\n        \"showline\": true,\n        \"ticks\": \"outside\",\n        \"zeroline\": false,\n        \"fixedrange\": true\n      },\n      \"yaxis\": {\n        \"domain\": [0,1],\n        \"title\": \"\",\n        \"range\": y_range,\n        \"showgrid\": false,\n        \"zeroline\": false,\n        \"showticklabels\": false,\n        \"fixedrange\": true\n      },\n      \"shapes\": [\n        {\n          \"type\": \"line\",\n          \"y0\": y_range[0],\n          \"y1\": y_range[1],\n          \"yref\": \"paper\",\n          \"x0\": vline,\n          \"x1\": vline,\n          \"line\": {\n            \"color\": color_vline\n          }\n        }\n      ],\n      \"plot_bgcolor\": \"rgba(0, 0, 0, 0)\",\n      \"paper_bgcolor\": \"rgba(0, 0, 0, 0)\",\n      \"hoverlabel\": {\n        \"bgcolor\": \"lightgray\"\n      },\n      \"showlegend\": showlegend,\n      \"hovermode\": \"closest\",\n      \"legend\": {\n        \"title\": {\n          \"text\": legend_title\n        },\n        \"orientation\": \"h\",\n        \"xanchor\": \"center\",\n        \"x\": 0.5,\n        \"y\": legend_position\n      }\n    },\n    \"config\": {\n      \"showSendToCloud\": false,\n      \"displayModeBar\": false\n    }\n  })\n}"

