% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf-functions.R
\name{hrf_sine}
\alias{hrf_sine}
\title{hrf_sine}
\usage{
hrf_sine(t, span = 24, N = 5)
}
\arguments{
\item{t}{A vector of times.}

\item{span}{The temporal window over which the basis sets span (default: 24).}

\item{N}{The number of basis functions (default: 5).}
}
\value{
A matrix of sine basis functions.
}
\description{
A hemodynamic response function using the Sine Basis Set.
}
\examples{
hrf_sine_basis <- hrf_sine(seq(0, 20, by = 0.5), N = 4)
}
\seealso{
Other hrf_functions: 
\code{\link{hrf_basis_lwu}()},
\code{\link{hrf_boxcar}()},
\code{\link{hrf_bspline}()},
\code{\link{hrf_gamma}()},
\code{\link{hrf_gaussian}()},
\code{\link{hrf_inv_logit}()},
\code{\link{hrf_lwu}()},
\code{\link{hrf_mexhat}()},
\code{\link{hrf_spmg1}()},
\code{\link{hrf_time}()},
\code{\link{hrf_weighted}()}
}
\concept{hrf_functions}
