% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{fm_centroids}
\alias{fm_centroids}
\title{Extract triangle centroids from an \code{fm_mesh_2d}}
\usage{
fm_centroids(x, format = NULL)
}
\arguments{
\item{x}{An \code{fm_mesh_2d} object.}

\item{format}{character; \code{"sf"}, \code{"df"}, \code{"sp"}}
}
\value{
An \code{sf}, \code{data.frame}, or \code{SpatialPointsDataFrame} object, with the vertex
coordinates, and a \code{.triangle} column with the triangle indices.
}
\description{
Computes the centroids of the triangles of an \code{\link[=fm_mesh_2d]{fm_mesh_2d()}}
object.
}
\examples{
if (require("ggplot2", quietly = TRUE)) {
  vrt <- fm_centroids(fmexample$mesh, format = "sf")
  ggplot() +
    geom_sf(data = fm_as_sfc(fmexample$mesh)) +
    geom_sf(data = vrt, color = "red")
}

}
\seealso{
\code{\link[=fm_vertices]{fm_vertices()}}
}
\author{
Finn Lindgren \href{mailto:Finn.Lindgren@gmail.com}{Finn.Lindgren@gmail.com}
}
