% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppoisGE.R
\name{PoissonGeneralizedExponential}
\alias{PoissonGeneralizedExponential}
\alias{dpge}
\alias{ppge}
\alias{qpge}
\alias{rpge}
\title{Poisson-Generalized-Exponential Distribution}
\usage{
dpge(
  x,
  mean = 1,
  shape = 1,
  scale = 1,
  ndraws = 1500,
  log = FALSE,
  haltons = NULL
)

ppge(
  q,
  mean = 1,
  shape = 1,
  scale = 1,
  ndraws = 1500,
  lower.tail = TRUE,
  log.p = FALSE,
  haltons = NULL
)

qpge(p, mean = 1, shape = 1, scale = 1, ndraws = 1500)

rpge(n, mean = 1, shape = 1, scale = 1, ndraws = 1500)
}
\arguments{
\item{x}{numeric value or a vector of values.}

\item{mean}{numeric value or vector of mean values for the distribution (the
values have to be greater than 0). This is NOT the value of \eqn{\lambda}.}

\item{shape}{numeric value or vector of shape values for the shape parameter
of the generalized exponential distribution (the values have to be greater
than 0).}

\item{scale}{single value or vector of values for the scale parameter of the
generalized exponential distribution (the values have to be greater than
0).}

\item{ndraws}{the number of Halton draws to use for the integration.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{haltons}{an optional vector of Halton draws to use instead of ndraws.}

\item{q}{quantile or a vector of quantiles.}

\item{lower.tail}{logical; if TRUE, probabilities p are \eqn{P[X\leq x]}
otherwise, \eqn{P[X>x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{probability or a vector of probabilities.}

\item{n}{the number of random numbers to generate.}
}
\value{
dpge gives the density, ppge gives the distribution 
 function, qpge gives the quantile function, and rpge generates
 random  deviates.

 The length of the result is determined by n for rpge, and is the 
 maximum of the lengths of the numerical arguments for the other functions.
}
\description{
These functions provide density, distribution function, quantile function,
and random number generation for the Poisson-Generalized-Exponential (PGE)
Distribution
}
\details{
\code{dpge} computes the density (PDF) of the PGE Distribution.

\code{ppge} computes the CDF of the PGE Distribution.

\code{qpge} computes the quantile function of the PGE Distribution.

\code{rpge} generates random numbers from the PGE Distribution.

The Generalized Exponential distribution can be written as a function with a
shape parameter \eqn{\alpha>0} and scale parameter \eqn{\gamma>0}. The
distribution has strictly positive continuous values. The PDF of the
distribution is:
\deqn{f(x|\alpha,\gamma) = 
  \frac{\alpha}{\gamma} 
  \left(1-e^{-\frac{x}{\gamma}}\right)^{\alpha-1} 
  e^{-\frac{x}{\gamma}}} 

Thus, the compound Probability Mass Function(PMF) for the PGE distribution
is:
\deqn{f(y|\lambda,\alpha,\beta) = 
  \int_0^\infty 
     \frac{\lambda^y x^y e^{-\lambda x}}{y!}
     \frac{\alpha}{\gamma}
     \left(1-e^{-\frac{x}{\gamma}}\right)^{\alpha-1}e^{-\frac{x}{\gamma}} dx}

The expected value of the distribution is:
\deqn{E[y]=\mu=\lambda \left(\frac{\psi(\alpha+1)-\psi(1)}{\gamma}\right)}

Where \eqn{\psi(\cdot)} is the digamma function.

The variance is:
\deqn{\sigma^2 = 
  \lambda \left(\frac{\psi(\alpha+1)-\psi(1)}{\gamma}\right) + 
          \left(\frac{-\psi'(\alpha+1)+\psi'(1)}{\gamma^2}\right)\lambda^2}

Where \eqn{\psi'(\cdot)} is the trigamma function.

To ensure that \eqn{\mu=e^{X\beta}}, \eqn{\lambda} is replaced with:
\deqn{\lambda=\frac{\gamma e^{X\beta}}{\psi(\alpha+1)-\psi(1)}}

This results in:
\deqn{
  f(y|\mu,\alpha,\beta) =
  \int_0^\infty
    \frac{
      \left(
        \frac{\gamma e^{X\beta}}{\psi(\alpha+1)-\psi(1)}
      \right)^y
      x^y
      e^{
        -\left(
          \frac{\gamma e^{X\beta}}{\psi(\alpha+1)-\psi(1)}
        \right) x
      }
    }{
      y!
    }
    \frac{\alpha}{\gamma}
    \left(
      1-e^{-\frac{x}{\gamma}}
    \right)^{\alpha-1}
    e^{-\frac{x}{\gamma}}
    dx
}

Halton draws are used to perform simulation over the lognormal distribution
to solve the integral.
}
\examples{
dpge(0, mean=0.75, shape=2, scale=1, ndraws=2000)
ppge(c(0,1,2,3,4,5,6), mean=0.75, shape=2, scale=1, ndraws=500)
qpge(c(0.1,0.3,0.5,0.9,0.95), mean=0.75, shape=2, scale=1, ndraws=500)
rpge(30, mean=0.75,  shape=2, scale=1, ndraws=500)

}
\references{
Gupta, R. D., & Kundu, D. (2007). Generalized exponential distribution:
Existing results and some recent developments. Journal of Statistical
planning and inference, 137(11), 3537-3547.
}
