% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResourceIsolation.R
\name{ResourceIsolation}
\alias{ResourceIsolation}
\title{Fetch metadata based resource isolation plugin}
\description{
This plugin uses the information provided in the \verb{Sec-Fetch-*} request
headers to block unwanted requests to your server coming from other sites.
Setting up a strict control with which requests are allowed is an important
part of preventing some cross-site leaks as well as cross-site request
forgery attacks.
}
\details{
Compared to the other security measures in firesafety, the reource isolation
plugin is a server-side blocker of requests. Both CORS and CORP sends back a
full response and it is then up to the browser to determine if the response
becomes available to the site. In contrast, this plugin will return a 403
response if the request fails to be accepted. This is not to say that
resource isolation is \emph{better} than CORS, CORP or other measures. They all
target different situations (or the same situation from different angles) and
works best in unison. You can read more about this type of defence at
\href{https://developer.mozilla.org/docs/Web/Security/Attacks/XS-Leaks#fetch_metadata}{MDN}
and \href{https://xsleaks.dev/docs/defenses/isolation-policies/resource-isolation/}{XS-Leaks Wiki}
\subsection{How it works}{

Resource isolation takes advantage of the \verb{Sec-Fetch-*} headers that browser
send along with requests. These headers informs the server about the nature
of the request. Where it comes from, what action initiated it, and how it
will be used. Based on this information the server may chose to allow a
request to proceed or deny it altogether. This plugin runs a request through
a range of tests and if it passes \emph{any} of them it proceeds:
\enumerate{
\item Does the request have the \verb{Sec-Fetch-*} headers
\item Is \code{allow_cors == TRUE} and is \code{Sec-Fetch-Mode} set to \code{cors}
\item Is \code{Sec-Fetch-Site} set to \code{allowed_site} or a more restrictive value
\item Is the request method \code{GET}, the \code{Sec-Fetch-Mode} \code{navigation}, and the
\code{Sec-Fetch-Dest} not one of those given by \code{forbidden_navigation}
}

You can have different permissions for different paths. The default during
initialization is to add it to \verb{/*} so that all all paths will share the same
policy, but you can strengthen or loosen up specific paths as needed. A good
rule of thumb is to make the policy as restrictive as possible while allowing
your application to still work as intented. Further, if you have paths that
do not have a resource isolation policy in place these should have CORS
enabled.
}
}
\section{Initialization}{

A new 'ResourceIsolation'-object is initialized using the \code{new()} method on the
generator and pass in any settings deviating from the defaults

\strong{Usage}
\tabular{l}{
\code{resource_isolation <- ResourceIsolation$new(...)}
}
}

\section{Fiery plugin}{

A ResourceIsolation object is a fiery plugin and can be used by passing it
to the \code{attach()} method of the fiery server object. Once attached all
requests will be passed through the plugin and the policy applied to it
}

\examples{
# Create resource isolation policy denying all navigation requests
resource_isolation <- ResourceIsolation$new(forbidden_navigation = "all")

# Allow cross-site requests on a subpath
resource_isolation$add_path(
  path = "/all_is_welcome/*",
  allowed_site = "cross-site"
)

\dontshow{if (requireNamespace("fiery", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Use it in a fiery server
app <- fiery::Fire$new()

app$attach(resource_isolation)
\dontshow{\}) # examplesIf}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{The name of the plugin}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResourceIsolation-new}{\code{ResourceIsolation$new()}}
\item \href{#method-ResourceIsolation-add_path}{\code{ResourceIsolation$add_path()}}
\item \href{#method-ResourceIsolation-on_attach}{\code{ResourceIsolation$on_attach()}}
\item \href{#method-ResourceIsolation-clone}{\code{ResourceIsolation$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResourceIsolation-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResourceIsolation-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new ResourceIsolation object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResourceIsolation$new(
  path = "/*",
  allowed_site = "same-site",
  forbidden_navigation = c("object", "embed"),
  allow_cors = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The path that the policy should apply to. routr path syntax
applies, meaning that wilcards and path parameters are allowed.}

\item{\code{allowed_site}}{The allowance level to permit. Either \code{cross-site},
\code{same-site}, or \code{same-origin}.}

\item{\code{forbidden_navigation}}{A vector of destinations not allowed for
navigational requests. See the \href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Reference/Headers/Sec-Fetch-Dest}{\code{Sec-Fetch-Dest} documentation}
for a description of possible values. The special value \code{"all"} is also
permitted which is the equivalent of passing all values.}

\item{\code{allow_cors}}{Should \code{Sec-Fetch-Mode: cors} requests be allowed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResourceIsolation-add_path"></a>}}
\if{latex}{\out{\hypertarget{method-ResourceIsolation-add_path}{}}}
\subsection{Method \code{add_path()}}{
Add a policy to a path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResourceIsolation$add_path(
  path,
  allowed_site,
  forbidden_navigation = c("object", "embed"),
  allow_cors = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The path that the policy should apply to. routr path syntax
applies, meaning that wilcards and path parameters are allowed.}

\item{\code{allowed_site}}{The allowance level to permit. Either \code{cross-site},
\code{same-site}, or \code{same-origin}.}

\item{\code{forbidden_navigation}}{A vector of destinations not allowed for
navigational requests. See the \href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Reference/Headers/Sec-Fetch-Dest}{\code{Sec-Fetch-Dest} documentation}
for a description of possible values. The special value \code{"all"} is also
permitted which is the equivalent of passing all values.}

\item{\code{allow_cors}}{Should \code{Sec-Fetch-Mode: cors} requests be allowed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResourceIsolation-on_attach"></a>}}
\if{latex}{\out{\hypertarget{method-ResourceIsolation-on_attach}{}}}
\subsection{Method \code{on_attach()}}{
Method for use by \code{fiery} when attached as a plugin. Should
not be called directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResourceIsolation$on_attach(app, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{app}}{The fiery server object}

\item{\code{...}}{Ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResourceIsolation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResourceIsolation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResourceIsolation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
