% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hierarchy.R
\name{get_hierarchy}
\alias{get_hierarchy}
\title{Get the hierarchical context for a specific concept from the Finto Skosmos API}
\usage{
get_hierarchy(vocid, uri, lang = NULL)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{uri}{The URI of the concept whose hierarchical context to retrieve.}

\item{lang}{The language code for the labels, e.g., "fi" or "en". Optional.}
}
\value{
A tibble containing the hierarchical context (broader, narrower, prefLabel, etc.) for the specified concept.
}
\description{
Get the hierarchical context for a specific concept from the Finto Skosmos API
}
\examples{
hierarchy <- get_hierarchy(vocid = "yso", uri = "http://www.yso.fi/onto/yso/p24489", lang = "fi")
print(hierarchy)
}
