% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_concept_labels_vocid.R
\name{get_concept_labels_vocid}
\alias{get_concept_labels_vocid}
\title{Get labels for a specific concept from the Finto Skosmos API}
\usage{
get_concept_labels_vocid(vocid, uri, lang = NULL)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{uri}{The URI of the concept whose labels to retrieve.}

\item{lang}{The language code for the labels, e.g., "fi" or "en". Optional.}
}
\value{
A tibble containing the labels (prefLabel, altLabel, hiddenLabel) for the specified concept.
}
\description{
Get labels for a specific concept from the Finto Skosmos API
}
\examples{
lables <- get_concept_labels_vocid(vocid = "yso",
uri = "http://www.yso.fi/onto/yso/p22922", lang = "fi")
print(lables)
}
