% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_broader_concepts.R
\name{get_broader_concepts}
\alias{get_broader_concepts}
\title{Get broader concepts for a specific concept from the Finto Skosmos API}
\usage{
get_broader_concepts(vocid, uri, lang = NULL)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{uri}{The URI of the concept whose broader concepts to retrieve.}

\item{lang}{The language code for the labels, e.g., "fi" or "en". Optional.}
}
\value{
A tibble containing the broader concepts (prefLabel and uri) for the specified concept.
}
\description{
Get broader concepts for a specific concept from the Finto Skosmos API
}
\examples{
conepts <- get_broader_concepts(vocid = "yso",
uri = "http://www.yso.fi/onto/yso/p22922", lang = "fi")
print(conepts)
}
