% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_kanto_info.R
\name{fetch_kanto_info}
\alias{fetch_kanto_info}
\title{Fetch RDF data for a specific concept from the Finto Skosmos API using a single asteriID}
\usage{
fetch_kanto_info(asteriID, format = "application/json")
}
\arguments{
\item{asteriID}{The unique identifier to append to the base URI.}

\item{format}{The MIME type of the serialization format (e.g., "application/rdf+xml" or "text/turtle"). Default is "application/json".}
}
\value{
A tibble containing the RDF data for the concept.
}
\description{
This function retrieves RDF data for a given concept from the Finto API.
The user only needs to provide the asteriID, which is appended to a fixed base URI.
}
\examples{
concept_data <- fetch_kanto_info(asteriID = "000094320")
print(concept_data)
}
