% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.findn.R
\name{plot.findn}
\alias{plot.findn}
\title{Plot of a findn Object}
\usage{
\method{plot}{findn}(x, min_n = 1, max_n = NULL, power_lim = 0.95, ...)
}
\arguments{
\item{x}{object of class \code{findn}.}

\item{min_n}{lower limit of the x-axis.}

\item{max_n}{upper limit of the x-axis. The default is \code{NULL}.}

\item{power_lim}{if \code{max_n} is \code{NULL} then the upper limit of the x-axis is the 
smallest sample size for which the lower limit of the \code{level} percent confidence interval
for the predicted power exceeds the value of \code{power_lim}. The default is 0.95.}

\item{...}{Further arguments.}
}
\value{
None.
}
\description{
Plot of a findn Object
}
\examples{
# Function that simulates the outcomes of a two-sample t-test
ttest <- function(mu1 = 0, mu2 = 1, sd, n, k) {
  sample1 <- matrix(rnorm(n = ceiling(n) * k, mean = mu1, sd = sd),
    ncol = k)
  mean1 <- apply(sample1, 2, mean)
  sd1_hat <- apply(sample1, 2, sd)
  sample2 <- matrix(rnorm(n = ceiling(n) * k, mean = mu2, sd = sd),
    ncol = k)
  mean2 <- apply(sample2, 2, mean)
  sd2_hat <- apply(sample2, 2, sd)
  sd_hat <- sqrt((sd1_hat^2 + sd2_hat^2) / 2)
  teststatistic <- (mean1 - mean2) / (sd_hat * sqrt(2 / n))
  crit <- qt(1 - 0.025, 2*n - 2)
  return(mean(teststatistic < -crit))
}

# Create a findn object
res.ttest <- findn(fun = ttest, targ = 0.8, k = 25, start = 100, 
  init_evals = 100, r = 4, stop = "evals", max_evals = 2000, 
  level = 0.05, var_a = 0.05, var_b = 1, alpha = 0.025, 
  alternative = "one.sided", sd = 2, verbose = FALSE)

# plot with default settings
plot(res.ttest, power_lim = 0.95)
}
