% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_var.R
\name{add_var}
\alias{add_var}
\alias{add_lxly}
\alias{add_qxqy}
\alias{add_index}
\alias{add_col_row}
\alias{add_hectindex}
\alias{add_quad}
\alias{add_gxgy}
\title{Add columns \code{lx/ly}, \code{QX/QY}, \code{index}, \code{col/row}, \code{hectindex}, \code{quad}, \code{gx/gy}.}
\usage{
add_lxly(data, gridsize = 20, plotdim = NULL)

add_qxqy(data, gridsize = 20, plotdim = NULL)

add_index(data, gridsize = 20, plotdim = NULL)

add_col_row(data, gridsize = 20, plotdim = NULL)

add_hectindex(data, gridsize = 20, plotdim = NULL)

add_quad(data, gridsize = 20, plotdim = NULL, start = NULL, width = 2)

add_gxgy(data, gridsize = 20, start = 0)
}
\arguments{
\item{data}{A ForestGEO-like dataframe: A \emph{ViewFullTable}, \emph{tree} or \emph{stem}
table.}

\item{gridsize}{The gridsize of the census plot (commonly 20 m).}

\item{plotdim}{The global dimensions of the census plot (i.e. the
maximum possible values of \code{gx} and \code{gy}).}

\item{start}{Defaults to label the first quadrat as "0101". Use \code{0} to
label it as "0000" instead.}

\item{width}{Number; width to pad the labels of plot-columns and -rows.}
}
\value{
For any given \code{var}, a function \code{add_var()} returns a modified
version of the input dataframe, with the additional variable(s) \code{var}.
}
\description{
These functions add columns to position trees in a forest plot. They work
with \emph{ViewFullTable}, \emph{tree} and \emph{stem} tables. From the input table, most
functions use only the \code{gx} and \code{gy} columns (or equivalent columns). The
exception is the function \code{add_gxgy()} which inputs quadrat information. If
your data lacks some important column, an error message will inform you which
column is missing.
}
\details{
These functions are adapted from the \href{https://forestgeo.si.edu/explore-data/r-package-0}{CTFS R Package}.
}
\examples{
# styler: off
x <- tribble(
    ~gx,    ~gy,
      0,      0,
     50,     25,
  999.9, 499.95,
   1000,    500
)
# styler: on

# `gridsize` has a common default; `plotdim` is guessed from the data
add_lxly(x)

gridsize <- 20
plotdim <- c(1000, 500)

add_qxqy(x, gridsize, plotdim)

add_index(x, gridsize, plotdim)

add_hectindex(x, gridsize, plotdim)

add_quad(x, gridsize, plotdim)

add_quad(x, gridsize, plotdim, start = 0)

# `width` gives the nuber of digits to pad the label of plot-rows and
# plot-columns, e.g. 3 pads plot-rows with three zeros and plot-columns with
# an extra trhree zeros, resulting in a total of 6 zeros.
add_quad(x, gridsize, plotdim, start = 0, width = 3)

add_col_row(x, gridsize, plotdim)


# From `quadrat` or `QuadratName` --------------------------------------
# styler: off
x <- tribble(
  ~QuadratName,
        "0001",
        "0011",
        "0101",
        "1001"
)
# styler: on

# Output `gx` and `gy` ---------------

add_gxgy(x)

assert_is_installed("fgeo.x")
# Warning: The data may already have `gx` and `gx` columns
gxgy <- add_gxgy(fgeo.x::tree5)
select(gxgy, matches("gx|gy"))

# Output `col` and `row` -------------

# Create columns `col` and `row` from `QuadratName` with `tidyr::separate()`
# The argument `sep` lets you separate `QuadratName` at any positon
\dontrun{
tidyr_is_installed <- requireNamespace("tidyr", quietly = TRUE)
stringr_is_installed <- requireNamespace("stringr", quietly = TRUE)

if (tidyr_is_installed && stringr_is_installed) {
  library(tidyr)
  library(stringr)

  vft <- tibble(QuadratName = c("0001", "0011"))
  vft

  separate(
    vft,
    QuadratName,
    into = c("col", "row"),
    sep = 2
  )

  census <- select(fgeo.x::tree5, quadrat)
  census

  census$quadrat <- str_pad(census$quadrat, width = 4, pad = 0)

  separate(
    census,
    quadrat,
    into = c("col", "row"),
    sep = 2,
    remove = FALSE
  )
}
}

}
\seealso{
Other functions to add columns to dataframes: 
\code{\link{add_status_tree}()},
\code{\link{add_subquad}()}

Other functions for ForestGEO data: 
\code{\link{add_status_tree}()},
\code{\link{add_subquad}()}

Other functions for fgeo census: 
\code{\link{add_status_tree}()},
\code{\link{guess_plotdim}()},
\code{\link{pick_drop}}

Other functions for fgeo vft: 
\code{\link{add_status_tree}()},
\code{\link{add_subquad}()},
\code{\link{guess_plotdim}()},
\code{\link{pick_drop}}
}
\concept{functions for ForestGEO data}
\concept{functions for fgeo census}
\concept{functions for fgeo vft}
\concept{functions to add columns to dataframes}
