% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_flag-connect_user.R
\name{is_enabled.connect_user_feature_flag}
\alias{is_enabled.connect_user_feature_flag}
\title{Checks if the given connect user feature flag is enabled}
\usage{
\method{is_enabled}{connect_user_feature_flag}(feature_flag)
}
\arguments{
\item{feature_flag}{flag to be checked whether it is
enabled}
}
\value{
TRUE if the feature flag is enabled.
}
\description{
Checks if the given connect user feature flag is enabled
}
\details{
The session$user field is used for retrieving the information
on the logged-in user
}
\examples{
{
  flag <- create_connect_user_feature_flag(c("user1"))

  # Returns TRUE if the session$user matches the specified users
  mock_session <- shiny::MockShinySession$new()
  mock_session$user <- "user1"
  shiny::withReactiveDomain(
    domain = mock_session,
    expr = is_enabled(flag)
  )

  # Returns FALSE if the session$user does not match the specified users
  mock_session <- shiny::MockShinySession$new()
  mock_session$user <- "user2"
  shiny::withReactiveDomain(
    domain = mock_session,
    expr = is_enabled(flag)
  )
}
}
