% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{norm2nbinom}
\alias{norm2nbinom}
\title{Convert normal to negative binomial}
\usage{
norm2nbinom(
  x,
  size,
  prob,
  mu,
  lower.tail = TRUE,
  log.p = FALSE,
  x_mu = mean(x),
  x_sd = stats::sd(x)
)
}
\arguments{
\item{x}{the normally distributed vector}

\item{size}{target for number of successful trials, or dispersion parameter (the shape parameter of the gamma mixing distribution). (size > 0)}

\item{prob}{the probability of success on each trial (0 to 1)}

\item{mu}{alternative parametrization via mean (only specify one of prob or mu)}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[$X <= x$], otherwise, P[$X > x$]}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p)}

\item{x_mu}{the mean of x (calculated from x if not given)}

\item{x_sd}{the SD of x (calculated from x if not given)}
}
\value{
a vector with a negative binomial distribution
}
\description{
See the help for `qnbinom()` for further info about prob versus mu parameter specification. Thanks for the suggested code, David Hugh-Jones!
}
\examples{

x <- rnorm(10000)
y <- norm2nbinom(x, 1, prob = 0.5)
z <- norm2nbinom(x, 1, mu = 1)
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
