% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-utils.R
\name{get_eim_chile}
\alias{get_eim_chile}
\alias{get_eim_chile()}
\title{Extracts voting and demographic data matrices for a given electoral district in Chile.}
\usage{
get_eim_chile(
  elect_district = NULL,
  region = NULL,
  merge_blank_null = TRUE,
  remove_mismatch = FALSE,
  use_sex = FALSE
)
}
\arguments{
\item{elect_district}{A string indicating the name of the electoral district to extract (e.g., "NIEBLA"). See \strong{Note}.}

\item{region}{A string indicating the name of the region to extract (e.g, "DE TARAPACA"). See \strong{Note}.}

\item{merge_blank_null}{Logical indicating whether blank and null votes should be merged into a single column. Defaults to \code{TRUE}.}

\item{remove_mismatch}{Logical indicating whether to remove ballot boxes with mismatched vote totals (where \code{MISMATCH == TRUE}). Defaults to \code{FALSE}.}

\item{use_sex}{Logical indicating whether to use the sex from the voters instead of the age ranges. Defaults to \code{FALSE}.}
}
\value{
An \code{\link{eim}} object with the following attributes:
\itemize{
\item \strong{X}: A matrix \verb{(b x c)} with the number of votes per candidate (including a column for blank + null votes if \code{merge_blank_null = TRUE}).
\item \strong{W}: A matrix \verb{(b x g)} with the number of voters per group (e.g., age ranges) for each ballot box.
}

This object can be passed to functions like \code{\link{run_em}} or \code{\link{get_agg_proxy}} for estimation and group aggregation. See \strong{Example}.
}
\description{
This function retrieves the voting results and demographic covariates for a given electoral district from the 2021 Chilean election dataset included in this package. The function returns an \code{\link{eim}} object that can be directly used in \code{\link{run_em}} or other estimation functions.
}
\details{
The function builds the \code{X} matrix using the number of votes per candidate, and the \code{W} matrix using the number of voters in each demographic group (e.g., age ranges). Optionally, blank and null votes can be merged into a single additional column (considered as another candidate).

Additionally, ballot boxes where the number of votes does not match the number of registered voters (i.e., those where \code{MISMATCH == TRUE}) can be excluded from the dataset by setting \code{remove_mismatch = TRUE}.
}
\note{
Only one parameter is accepted among \code{elect_district} and \code{region}. If either both parameters are given, it will return an error. If neither of these two inputs is supplied, it will return an eim object with an aggregation corresponding to the whole dataset. To see all electoral districts and regions names, see the function \link{chile_election_2021}.
}
\examples{
# Load data and create an eim object for the electoral district of "NIEBLA"
eim_obj <- get_eim_chile(elect_district = "NIEBLA", remove_mismatch = FALSE)

# Use it to run the EM algorithm
result <- run_em(eim_obj, allow_mismatch = TRUE)

# Use it with group aggregation
agg_result <- get_agg_proxy(
    object = eim_obj,
    sd_threshold = 0.05,
    allow_mismatch = TRUE,
    seed = 123
)

agg_result$group_agg

}
\seealso{
\link{chile_election_2021}
}
