% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_sim_functions.R
\name{sim_functions}
\alias{sim_functions}
\alias{rnorm_s}
\alias{rstd_s}
\alias{rged_s}
\alias{rsged_s}
\alias{rald_s}
\alias{rsnorm_s}
\alias{rsstd_s}
\alias{rsald_s}
\title{Sampling Functions for Innovations}
\usage{
rnorm_s(n)

rstd_s(n, df = 10000)

rged_s(n, shape = 2)

rsged_s(n, shape = 2, skew = 1)

rald_s(n, P = 8)

rsnorm_s(n, skew = 1)

rsstd_s(n, df = 10000, skew = 1)

rsald_s(n, P = 8, skew = 1)
}
\arguments{
\item{n}{the number of observations to draw.}

\item{df}{the degrees of freedom for a (skewed) \eqn{t}-distribution.}

\item{shape}{the shape parameter for a (skewed) generalized error
distribution.}

\item{skew}{the skewness parameter in the skewed distributions.}

\item{P}{the number of Laplace distributions (minus 1) to derive the arithmetic
mean from as the basis for a (skewed) average Laplace (AL) distribution
distribution.}
}
\value{
These functions return a numeric vector of length \code{n}.
}
\description{
Draw random samples from a normal distribution, \eqn{t}-distribution,
generalized error distribution, or their skewed variants (all standardized
to have mean zero and variance one).
}
\details{
Draw random samples from a normal distribution, \eqn{t}-distribution,
generalized error distribution, an average Laplace distribution,
or their skewed variants (all standardized to have mean zero and
variance one).
}
\examples{
rnorm_s(10)

rsstd_s(10, df = 7, skew = 0.9)
}
