% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toHTML.R
\name{toHTML.html_matrix}
\alias{toHTML.html_matrix}
\alias{toLatex}
\alias{toHTMLorLatex}
\alias{toLatex.html_matrix}
\title{Export Matrices as HTML or LaTeX}
\usage{
\method{toHTML}{html_matrix}(x, browser = FALSE, delay = 2, ...)

\method{toLatex}{html_matrix}(object, ...)

toHTMLorLatex(x, ...)
}
\arguments{
\item{x, object}{An object of class \code{html_matrix}.}

\item{browser}{Logical; if \code{TRUE}, the HTML output is opened in a browser (default \code{FALSE}).
Only used by \code{toHTML}.}

\item{delay}{Numeric; seconds to wait before deleting temporary HTML files. A value of \code{0}
keeps the file until the R session ends. Only used by \code{toHTML}.}

\item{...}{Additional arguments passed to \code{\link[utils:browseURL]{utils::browseURL()}} (only relevant for \code{toHTML}).}
}
\value{
A character string containing the HTML or LaTeX representation of the matrix.
}
\description{
Convert a matrix to a formatted representation in HTML or LaTeX:
\itemize{
\item \code{toHTML}: Returns an HTML table of a matrix. Optionally displays it in a browser
via a temporary file using \code{\link[utils:browseURL]{utils::browseURL()}}.
\item \code{toLatex}: Returns a LaTeX table representation. Supports a subset of style options.
\item \code{toHTMLorLatex}: Chooses HTML or LaTeX output based on the presence of \code{exams2pdf}
in the call stack.
}
}
\examples{
library("tools")
m  <- matrix(1:12, ncol = 4)
hm <- html_matrix(m)
# toHTML(hm, browser = TRUE) # opens into browser
toHTML(hm)
toLatex(hm)
toHTMLorLatex(hm)
}
