% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pearson_data.R
\name{pearson_data}
\alias{pearson_data}
\alias{dpearson}
\title{Pearson Data}
\usage{
pearson_data(r, n = 100, nmax = 6, maxt = 30, xsos = NULL, ysos = NULL)

dpearson(r, n = 100, nmax = 6, maxt = 30, xsos = NULL, ysos = NULL)
}
\arguments{
\item{r}{numeric: desired correlation}

\item{n}{integer: number to decompose as sum of squares, see \code{\link[=sumofsquares]{sumofsquares()}}.}

\item{nmax}{integer: maximal number of squares in the sum, see \code{\link[=sumofsquares]{sumofsquares()}}.}

\item{maxt}{numeric: maximal number of seconds the routine should run, see \code{\link[=sumofsquares]{sumofsquares()}}.}

\item{xsos}{sos matrix: precomputed matrix}

\item{ysos}{sos matrix: precomputed matrix}
}
\value{
A matrix with two columns and an attribute \code{interim} for intermediate values as matrix.
The rows of the matrix contain : \eqn{x_i}, \eqn{y_i},  \eqn{x_i-bar{x}}, \eqn{y_i-\bar{y}},
\eqn{(x_i-bar{x})^2}, \eqn{(y_i-\bar{y})^2}, and \eqn{(x_i-bar{x})((y_i-\bar{y})}.
In a final step, a vector with the row of sums is appended as a further column.
}
\description{
Generates an integer data set for computing a correlation using \code{\link[=sumofsquares]{sumofsquares()}}.
If \code{n>100} and \code{nmax>6} it is better to use one of the precomputed solutions. Otherwise it may take
up to \code{maxt} seconds. Please note that the correlation of the generated data set may differ from the desired
correlation.
}
\examples{
data(sos100, package="exams.forge")
xy <- pearson_data(0.7, xsos=sos100)
colSums(xy)
colSums(xy^2)
sum(xy[,1]*xy[,2])
# my data
x <- 100+5*xy[,1]
y <- 100+5*xy[,2]
cor(x, y)
}
