% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_batch.R
\name{download_batch}
\alias{download_batch}
\title{download_batch(): Batch download files using multi_download (parallel with curl)}
\usage{
download_batch(
  urls,
  dest_dir,
  overwrite = FALSE,
  unzip = FALSE,
  workers = 4,
  verbose = TRUE,
  timeout = 600,
  resume = FALSE,
  speed_limit = NULL,
  retries = 3
)
}
\arguments{
\item{urls}{Character vector. List of URLs to download.}

\item{dest_dir}{Character. Destination directory (required). Use tempdir() for examples/tests.}

\item{overwrite}{Logical. Whether to overwrite existing files. Default: FALSE.}

\item{unzip}{Logical. Whether to unzip after download (for supported formats). Default: FALSE.}

\item{workers}{Integer. Number of parallel workers. Default: 4.}

\item{verbose}{Logical. Show download progress messages. Default: TRUE.}

\item{timeout}{Integer. Timeout in seconds for each download. Default: 600.}

\item{resume}{Logical. Whether to resume interrupted downloads. Default: FALSE.}

\item{speed_limit}{Numeric. Bandwidth limit in bytes/sec (e.g., 500000 = 500KB/s). Default: NULL.}

\item{retries}{Integer. Retry attempts if download fails. Default: 3.}
}
\value{
Invisibly returns a list of downloaded (and optionally unzipped) file paths.
}
\description{
A robust batch downloader that supports concurrent downloads with flexible options.
Built on top of \code{curl::multi_download()} for parallelism.
}
