% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comb.R
\name{comb}
\alias{comb}
\title{comb: Calculate Number of Combinations C(n, k)}
\usage{
comb(n, k)
}
\arguments{
\item{n}{Integer. Total number of items (non-negative integer).}

\item{k}{Integer. Number of items to choose (non-negative integer, must be <= n).}
}
\value{
Numeric. The combination count C(n, k) (returns Inf for very large n).
}
\description{
Calculates the total number of ways to choose k items from n distinct items (without regard to order),
i.e., the number of combinations C(n, k) = n! / (k! * (n - k)!).
This function is intended for moderate n and k. For very large values, consider the 'gmp' package.
}
\examples{
comb(8, 4)      # 70
comb(5, 2)      # 10
comb(10, 0)     # 1
comb(5, 6)      # 0
}
