% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VizForecastPDF.R
\name{VizForecastPDF}
\alias{VizForecastPDF}
\title{Plot one or multiple ensemble forecast pdfs for the same event}
\usage{
VizForecastPDF(
  fcst,
  tercile.limits,
  extreme.limits = NULL,
  obs = NULL,
  toptitle = "Set a title",
  title = NULL,
  var.name = "Varname (units)",
  title.legend = "Probability of terciles",
  strings.legend = c("Below normal", "Near normal", "Above normal"),
  ensemble.legend = "Ensemble members",
  obs.title = "Observations",
  strings.obs = NULL,
  title.extremes = "Probability of extremes",
  strings.extremes = c("Below p10", "Above p90"),
  xlab.title = "Probability density",
  fcst.names = NULL,
  title.cex = 1,
  labs.cex = 1,
  fcst.names.cex = 1,
  obs.lines = TRUE,
  obs.size = 3,
  add.ensmemb = c("above", "below", "no"),
  color.set = c("ggplot", "s2s4e", "hydro", "vitigeoss"),
  memb_dim = "member",
  width = 6,
  height = 5,
  fileout = NULL,
  plotfile = NULL,
  res = 300
)
}
\arguments{
\item{fcst}{A dataframe or array containing all the ensember members for each 
forecast. If \code{'fcst'} is an array, it should have two labelled 
dimensions, and one of them should be \code{'members'}. If \code{'fcsts'} is 
a data.frame, each column shoul be a separate forecast, with the rows beeing 
the different ensemble members.}

\item{tercile.limits}{An array or vector with P33 and P66 values that define 
the tercile categories for each panel. Use an array of dimensions 
(nforecasts,2) to  define different terciles for each forecast panel, or a 
vector with two elements to reuse the same tercile limits for all forecast 
panels.}

\item{extreme.limits}{(optional) An array or vector with P10 and P90 values 
that define the extreme categories for each panel. Use an array of 
(nforecasts,2) to define different extreme limits for each forecast panel, 
or a vector with two elements to reuse the same tercile limits for all 
forecast panels. (Default: extreme categories are not shown).}

\item{obs}{(optional) A vector providing the observed values for each forecast 
panel or a single value that will be reused for all forecast panels. 
(Default: observation is not shown).}

\item{toptitle}{A string with the plot main title.}

\item{title}{Deprecated. Use 'toptitle' instead.}

\item{var.name}{A string with the variable name and units.}

\item{title.legend}{A string with the title of the legend showing the 
probabilistic categories. By default, it is set to "Probability of terciles".}

\item{strings.legend}{A vector of strings with the name of the probabilistic 
categories. By default, it is set to c("Below normal", "Near normal", 
"Above normal").}

\item{ensemble.legend}{A string with the title of the legend showing the 
ensemble members. By default, it is set to "Ensemble members".}

\item{obs.title}{A string with the title of the legend showing the 
observations ('obs'). By default, it is set to "Observations".}

\item{strings.obs}{A vector of strings with the name of the observations, 
which correspond to the values of 'obs'. By default, it is set to NULL.}

\item{title.extremes}{A string with the title of the legend showing the 
extreme categories. By default, it is set to "Probability of extremes".}

\item{strings.extremes}{A vector of strings with the name of the extreme 
categories. By default, it is set to c("Below p10", "Above p90").}

\item{xlab.title}{A string with the title of the x-axis. By default, it is set
to "Probability density".}

\item{fcst.names}{(optional) A string or vector of strings with the titles of 
each individual forecast panel.}

\item{title.cex}{A number with the size of 'toptitle'. By default, it is set 
to 1.}

\item{labs.cex}{A number with the size of the labels in the axes. By default, 
it is set to 1.}

\item{fcst.names.cex}{A number with the size of the 'fcst.names'. By default, 
it is set to 1.}

\item{obs.lines}{A logical value indicating whether to draw horizontal lines 
at the height of the observations. The default value is TRUE.}

\item{obs.size}{A number with the size of the observation dots. By default, it
is set to 3.}

\item{add.ensmemb}{Either to add the ensemble members \code{'above'} (default)
or \code{'below'} the pdf, or not (\code{'no'}).}

\item{color.set}{A selection of predefined color sets: use \code{'ggplot'} 
(default) for blue/green/red, \code{'s2s4e'} for blue/grey/orange, 
\code{'hydro'} for yellow/gray/blue (suitable for precipitation and 
inflows) or the \code{"vitigeoss"} color set.}

\item{memb_dim}{A character string indicating the name of the member 
dimension.}

\item{width}{File width, in the units specified in the parameter size_units 
(inches by default). Takes 8 by default.}

\item{height}{File height, in the units specified in the parameter 
size_units (inches by default). Takes 5 by default.}

\item{fileout}{(optional) A filename (pdf, png...) where the plot will be 
saved. (Default: the plot is not saved).}

\item{plotfile}{Deprecated. Use 'fileout' instead.}

\item{res}{Resolution of the device (file or window) to plot in. See 
?Devices and the creator function of the corresponding device.}
}
\value{
A ggplot object containing the plot.
}
\description{
This function plots the probability distribution function of 
several ensemble forecasts. Separate panels are used to plot forecasts valid 
or initialized at different times or by different models or even at different 
locations. Probabilities for tercile categories are computed, plotted in 
colors and annotated. An asterisk marks the tercile with higher probabilities. 
Probabilities for extreme categories (above P90 and below P10) can also be 
included as hatched areas. Individual ensemble members can be plotted as 
jittered points. The observed value is optionally shown as a diamond.
}
\examples{
fcsts <- data.frame(fcst1 = rnorm(10), fcst2 = rnorm(10, 0.5, 1.2))
VizForecastPDF(fcsts,c(-1,1))

}
\author{
Llorenç Lledó \email{llledo@bsc.es}
}
