% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erah.R
\name{deconvolveComp}
\alias{deconvolveComp}
\alias{deconvolveComp,MetaboSet-method}
\title{Deconvolution of compounds in samples}
\usage{
deconvolveComp(
  Experiment,
  decParameters,
  samples.to.process = NULL,
  down.sample = FALSE,
  virtualScansPerSecond = NULL
)

\S4method{deconvolveComp}{MetaboSet}(
  Experiment,
  decParameters,
  samples.to.process = NULL,
  down.sample = FALSE,
  virtualScansPerSecond = NULL
)
}
\arguments{
\item{Experiment}{A 'MetaboSet' S4 object containing the experiment data previously created by newExp.}

\item{decParameters}{The software deconvolution parameters object previously created by setDecPar}

\item{samples.to.process}{Vector indicating which samples are to be processed.}

\item{down.sample}{If TRUE, chromatograms are down sampled to define one peak with 10 scan points (according to the minimum peak width). This is to process longer chromatograms with wider peak widths (more than 20 seconds peak width and small scans per second values). See details.}

\item{virtualScansPerSecond}{A virtual scans per second. If chromatograms are downsampled (for example, for a 1 mean peak width a 1 scans per second sampling frequency was used), eRah could not perform as expected. In these cases, the BEST solution is to re-acquire the samples. However, by selecting a different (virtual) scans per second frequency, eRah can upsample the data and process it more effectively.}
}
\value{
The function returns an updated S4 'MetaboSet' class, where the GC-MS samples have been now deconvolved.
}
\description{
Deconvolution of GC-MS data
}
\details{
See eRah vignette for more details. To open the vignette, execute the following code in R:
vignette("eRahManual", package="erah")

eRah uses multivariate methods which run-time performance depend on the amount of data to be analyzed. When peaks are wider and the #' scans per second is also a small value, the number of points (scans) that define a peak might be too many, leading eRah to a poor run#'-time performance. To solve that, use down.sample=TRUE to allow eRah to define a peak with 10 seconds, and analyze the data more #' efficiently.
}
\examples{
\dontrun{
# Deconvolve data from a created experiment by \code{\link{newExp}}.
# ex <- newExp(instrumental="path")

# The following will set eRah for analyzing the chromatograms
# from minutes 5 to 15, and withouth taking into account the masses
# 35:69,73:75,147:149, with a minimum peak width of 0.7 seconds.

ex.dec.par <- setDecPar(min.peak.width=0.7, min.peak.height=5000, 
                       noise.threshold=500, avoid.processing.mz=c(35:69,73:75,147:149), 
                       analysis.time=c(5,15))

# An now deconvolve the compounds in the samples:
# ex <- deconvolveComp(ex, decParameters=ex.dec.par)
}
}
\references{
[1] Xavier Domingo-Almenara, et al., eRah: A Computational Tool Integrating Spectral Deconvolution and Alignment with Quantification and Identification of Metabolites in GC-MS-Based Metabolomics. Analytical Chemistry (2016). DOI: 10.1021/acs.analchem.6b02927
}
\seealso{
\code{\link{newExp}} \code{\link{setAlPar}}
}
\author{
Xavier Domingo-Almenara. xavier.domingo@urv.cat
}
