% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{epiworld-summaries}
\alias{epiworld-summaries}
\alias{get_transition_probability}
\alias{get_active_cases}
\alias{get_outbreak_size}
\title{Summary counts and probabilities}
\usage{
get_transition_probability(x)

get_active_cases(x)

get_outbreak_size(x)
}
\arguments{
\item{x}{An object of class \code{\link{epiworld_sir}}, \code{\link{epiworld_seir}}, etc.
(any model).}
}
\value{
\itemize{
\item The \code{get_transition_probability} function returns an object of class
\code{matrix}.
}

\itemize{
\item The function \code{get_active_cases} returns a data.frame with four columns:
date, virus_id, virus, and active_cases indicating the number of active
cases (individuals with a virus) at each point in time.
}

\itemize{
\item The function \code{get_outbreak_size} returns a data.frame with four columns:
\code{date}, \code{virus_id}, \code{virus}, and \code{outbreak_size} indicating the outbreak
size per virus at each point in time.
}
}
\description{
Functions to extract summary statistics from models, including transition
probabilities, active cases, and outbreak sizes.
}
\examples{
# SEIR Connected model
seirconn <- ModelSEIRCONN(
  name              = "Disease",
  n                 = 10000,
  prevalence        = 0.1,
  contact_rate      = 2.0,
  transmission_rate = 0.8,
  incubation_days   = 7.0,
  recovery_rate     = 0.3
)

set.seed(937)
run(seirconn, 50)

# Retrieving the transition probability
get_transition_probability(seirconn)

# Get active cases
head(get_active_cases(seirconn))

# Get outbreak size
head(get_outbreak_size(seirconn))

}
\seealso{
Other Summaries: 
\code{\link{epiworld-hospitalizations}}
}
\concept{Summaries}
\concept{model-utility-functions}
