% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{gsea}
\alias{gsea}
\title{Gene Set Enrichment Analysis (GSEA)}
\usage{
gsea(
  geneList,
  gene_sets,
  minGSSize = 10,
  maxGSSize = 500,
  nPerm = 1000,
  exponent = 1,
  method = "multilevel",
  adaptive = FALSE,
  minPerm = 101,
  maxPerm = 1e+05,
  pvalThreshold = 0.1,
  eps = 1e-10,
  sampleSize = 101,
  seed = FALSE,
  nPermSimple = 1000,
  scoreType = "std",
  verbose = TRUE
)
}
\arguments{
\item{geneList}{A named numeric vector of gene statistics (e.g., log fold change), ranked in descending order.}

\item{gene_sets}{A named list of gene sets. Each element is a character vector of genes.}

\item{minGSSize}{minimal size of each geneSet for analyzing}

\item{maxGSSize}{maximal size of each geneSet for analyzing}

\item{nPerm}{Number of permutations for p-value calculation (default: 1000).}

\item{exponent}{Weighting exponent for enrichment score (default: 1.0).}

\item{method}{Permutation method.}

\item{adaptive}{Logical. Use adaptive permutation.}

\item{minPerm}{Minimum permutations for adaptive mode.}

\item{maxPerm}{Maximum permutations for adaptive mode.}

\item{pvalThreshold}{P-value threshold for early stopping.}

\item{eps}{Epsilon for multilevel methods (default: 1e-10). Sets the smallest p-value that can be estimated.}

\item{sampleSize}{Sample size for multilevel methods (default: 101).}

\item{seed}{Random seed for reproducibility (default: FALSE). If FALSE, a random seed is generated.}

\item{nPermSimple}{Number of permutations for the simple method (default: 1000).}

\item{scoreType}{Type of enrichment score calculation: "std", "pos", "neg" (default: "std").}

\item{verbose}{Logical. Print progress messages.}
}
\value{
A data.frame with columns:
\itemize{
\item \strong{ID}: Gene set name
\item \strong{enrichmentScore}: Enrichment Score
\item \strong{NES}: Normalized Enrichment Score
\item \strong{pvalue}: Empirical p-value from permutation test
\item \strong{setSize}: Size of the gene set (number of genes found in geneList)
\item \strong{nPerm}: (adaptive mode only) Actual number of permutations used
\item \strong{rank}: Rank at which the maximum enrichment score is attained
\item \strong{leading_edge}: Leading edge statistics (tags, list, signal)
\item \strong{core_enrichment}: Genes in the leading edge, separated by '/'
}
}
\description{
Perform Gene Set Enrichment Analysis (GSEA) using a ranked gene list.
}
\examples{
# Example data
stats <- rnorm(1000)
names(stats) <- paste0("Gene", 1:1000)
stats <- sort(stats, decreasing = TRUE)

gs1 <- paste0("Gene", 1:50)
gs2 <- paste0("Gene", 500:550)
gene_sets <- list(Pathway1 = gs1, Pathway2 = gs2)

# Use default fixed permutation method
result <- gsea(geneList=stats, gene_sets=gene_sets, nPerm=100)

# Use adaptive permutation for more accurate p-values
\donttest{
result_adaptive <- gsea(geneList=stats, gene_sets=gene_sets, adaptive=TRUE)
}

}
