% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emusegs.R
\name{modify.seglist}
\alias{modify.seglist}
\title{Modify one of the components of an Emu segment list}
\usage{
modify.seglist(
  segs,
  labels = label.emusegs(segs),
  start = start.emusegs(segs),
  end = end.emusegs(segs),
  utts = utt.emusegs(segs),
  query = emusegs.query(segs),
  type = emusegs.type(segs),
  database = emusegs.database(segs)
)
}
\arguments{
\item{segs}{A segment list to modify, a modified copy is returned}

\item{labels}{A new label vector}

\item{start}{A new start time vector}

\item{end}{A new end time vector}

\item{utts}{A new vector of utterance labels}

\item{query}{A new query string to associate with the segment list}

\item{type}{A new type string}

\item{database}{A new database name}
}
\value{
An Emu segment list.
}
\description{
This function can be used to modify one of the parts of an Emu segment list
while leaving the other parts unchanged.
}
\details{
An Emu segment list has a number of components and is stored as an R object
of class \code{emusegs}.  This function can be used to modify a segment
list while retaining all of the proper structures.

Any new vectors passed to the function must have the same length as the
segment list itself for this call to succeed.

All arguments are optional and default to not modifying the segment list if
not supplied.

The original segment list is not modified, instead, a modified copy is
returned.
}
\examples{

data(vowlax)
segs = vowlax
# extend the start times by 10ms
newsegs <- modify.seglist( segs, start=start(segs)+10 )

# change the associated database name
# this will affect where emu.track looks to find data
newsegs <-  modify.seglist( segs, database="notdemo" )


}
\seealso{
\code{\link{query}}
}
\author{
Steve Cassidy
}
\keyword{misc}
