% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.R
\name{expr_replace}
\alias{expr_replace}
\title{Replace patterns within expressions}
\usage{
expr_replace(expr, ..., patterns, replacements,
    n = Inf, env = parent.frame())
}
\arguments{
\item{expr}{Input. An \link[=elixir-expression]{expression}, \link{expr_list}, or
\code{\link[=list]{list()}} of expressions.}

\item{...}{Alternating series of patterns and replacements, each a single
\link[=elixir-expression]{expression} (though alternatives can be specified
with \verb{?}).}

\item{patterns}{Patterns to look for. An \link[=elixir-expression]{expression},
\link{expr_list}, or \code{\link[=list]{list()}} of expressions.}

\item{replacements}{Replacements, one for each pattern.}

\item{n}{Maximum number of times for each expression to make each
replacement; default is \code{Inf}.}

\item{env}{Environment for injections in \code{expr}, \code{pattern} (see
\link[=elixir-expression]{expression}).}
}
\value{
The input expression(s) with any replacements made.
}
\description{
Match and replace elements of patterns in an \link[=elixir-expression]{expression}
or a list of expressions.
}
\details{
Patterns follow the syntax for \code{\link[=expr_match]{expr_match()}}.
}
\examples{
# Example with alternating patterns and replacements
expr_replace({ 1 + 2 }, {1}, {one}, {2}, {two})

# Example with patterns and replacements in a list
expr_replace({ 1 + 2 }, patterns = expr_list({1}, {2}),
    replacements = expr_list({one}, {two}))

# Replace with captures
expr_replace({ 1 + 2 }, ~{ .A + .B }, { .A - .B })
}
\seealso{
\code{\link[=expr_match]{expr_match()}} to find patterns in expressions, and its cousins
\code{\link[=expr_count]{expr_count()}}, \code{\link[=expr_detect]{expr_detect()}}, \code{\link[=expr_extract]{expr_extract()}}, and \code{\link[=expr_locate]{expr_locate()}}.
}
