% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis-auto-edina.R
\name{autoplot.auto_edina}
\alias{autoplot.auto_edina}
\title{Graph the Auto EDINA Object}
\usage{
\method{autoplot}{auto_edina}(
  object,
  type = c("selection", "guessing", "slipping", "evolution"),
  ...
)
}
\arguments{
\item{object}{An \code{auto_edina} object.}

\item{type}{Kind of graph to display. Valid types: \code{"selection"} or \code{"evolution"}.}

\item{...}{Not used.}
}
\value{
A \code{ggplot2} object.
}
\description{
Presents either the fitting of model heuristics or the evolution of parameters
on a graph
}
\examples{
if(requireNamespace("simcdm", quietly = TRUE)) {

# Set a seed for reproducibility
set.seed(1512)

# Setup data simulation parameters
N = 2    # Number of Examinees / Subjects
J = 10   # Number of Items
K = 2    # Number of Skills / Attributes

# Note:
# Sample size and attributes have been reduced to create a minimally
# viable example that can be run during CRAN's automatic check.
# Please make sure to have a larger sample size...

# Assign slipping and guessing values for each item
ss = gs = rep(.2, J)

# Simulate an identifiable Q matrix
Q = simcdm::sim_q_matrix(J, K)

# Simulate subject attributes
subject_alphas = simcdm::sim_subject_attributes(N, K)

# Simulate items under the DINA model
items_dina = simcdm::sim_dina_items(subject_alphas, Q, ss, gs)

\donttest{
# Requires at least 15 seconds of execution time.
# Three EDINA models will be fit with increasing number of attributes.
model_set_edina = auto_edina(items_dina, k = 2:4)

# Visualize results results
autoplot(model_set_edina, type = "selection")

# Equivalent to:
model_selection_graph(model_set_edina)

# View model parameters
autoplot(model_set_edina, type = "guessing")

# Or directly call with:
parameter_evolution_graph(model_set_edina, type = "guessing")
}
}
}
\seealso{
\code{\link[=auto_edina]{auto_edina()}},
\code{\link[=best_model]{best_model()}},
\code{\link[=model_selection_graph]{model_selection_graph()}},
\code{\link[=parameter_evolution_graph]{parameter_evolution_graph()}}
}
