% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.init}
\alias{ec.init}
\title{Initialize a chart}
\usage{
ec.init(
  df = NULL,
  preset = TRUE,
  ...,
  series.param = NULL,
  tl.series = NULL,
  width = NULL,
  height = NULL
)
}
\arguments{
\item{df}{Optional data.frame to be preset as \href{https://echarts.apache.org/en/option.html#dataset}{dataset}, default NULL \cr
By default the first column is for X values, second column is for Y, and third is for Z when in 3D.\cr
Best practice is to have the grouping column placed last. Grouping column cannot be used as axis.\cr
Timeline requires a \emph{grouped data.frame} to build its \href{https://echarts.apache.org/en/option.html#options}{options}.\cr
If grouping is on multiple columns, only the first one is used to determine settings.}

\item{preset}{Boolean (default TRUE). Build preset attributes like dataset, series, xAxis, yAxis, etc.\cr
When preset is FALSE, these attributes need to be set explicitly.\cr}

\item{...}{Optional widget attributes. See Details. \cr}

\item{series.param}{Additional attributes for single preset series, default is NULL.\cr
Defines a \strong{single} series for both non-timeline and timeline charts. Default type is 'scatter'. \cr
\strong{Multiple} series need to be defined directly with \emph{series=list(list(type=...),list(type=...))} or added with \link{ec.upd}.}

\item{tl.series}{Deprecated, use \emph{timeline} and \emph{series.param} instead.\cr}

\item{width, height}{Optional valid CSS unit (like \code{'100\%'},
\code{'500px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}
}
\value{
A widget to plot, or to save and expand with more features.
}
\description{
Required to build a chart. In most cases this will be the only command necessary.
}
\details{
Command \emph{ec.init} creates a widget with \link[htmlwidgets]{createWidget}, then adds some ECharts features to it.\cr
Numerical indexes for series,visualMap,etc. are R-counted (1,2...)\cr

\strong{Presets} \cr
A \href{https://echarts.apache.org/en/option.html#dataset}{dataset} is pre-set when data.frame \strong{df} is present. \cr
When \strong{df} is grouped, more datasets with legend and series are also preset. \cr
Axes for some charts are preset with name and type when suitable.\cr
Plugin '3D' (load='3D') is required for GL series like \emph{scatterGL, linesGL}, etc. \cr
Plugins 'leaflet' and 'world' preset \emph{center} to the mean of all coordinates from \strong{df}. \cr
Users can delete or overwrite any presets as needed. \cr

\strong{Widget attributes} \cr
Optional echarty widget attributes include: \cr
\itemize{
\item elementId - Id of the widget, default is NULL(auto-generated, stored as \emph{echwid} variable for JS)
\item load - name(s) of plugin(s) to load. A character vector or comma-delimited string. default NULL.
\item ask - boolean to prompt user before downloading plugins when \emph{load} is present, default is FALSE.\cr
\verb{     } Could also be string 'loadRemote' to load plugins remotely.\cr
\item ctype - alternative way of setting chart type name, default is 'scatter'.\cr
\item js - single string or a vector with JavaScript expressions to evaluate.\cr
single: exposed \emph{chart} object (most common)\cr
vector: \verb{     } see code in \href{https://github.com/helgasoft/echarty/blob/main/demo/examples.R}{examples}\cr
\verb{     } First expression evaluated with exposed objects \emph{window} and \emph{echarts} \cr
\verb{     } Second is evaluated with exposed object \emph{opts}. \cr
\verb{     } Third is evaluated with exposed \emph{chart} object after initialization with \emph{opts} already set.
\item theme - name of built-in theme to apply, or JSON object from \emph{fromJSON}, see \emph{opts} in \href{https://echarts.apache.org/en/api.html#echarts.init}{echarts.init}\cr
\item iniOpts - a list of initialization options, see \emph{opts} in \href{https://echarts.apache.org/en/api.html#echarts.init}{echarts.init}\cr
\verb{     } Defaults: renderer='canvas', locale='EN', useDirtyRect=FALSE\cr
\item on,off,capture,group - chart instance properties, namely:\cr
\verb{     } on/off is a list of events to handle with JS, each in a list, see \href{https://echarts.apache.org/en/api.html#echartsInstance.on}{chart.on} and example below\cr
\verb{     } capture is a vector of event names to capture in Shiny, etc.\cr
\item connect,disconnect,register,etc. - see \href{https://echarts.apache.org/en/api.html#echarts}{echarts object} methods\cr
}

\strong{Built-in plugins} \cr
\itemize{
\item leaflet - Leaflet maps with customizable tiles, see \href{https://github.com/gnijuohz/echarts-leaflet#readme}{source}\cr
\item world  - world map with country boundaries, see \href{https://github.com/apache/echarts/tree/master/test/data/map/js}{source} \cr
\item lottie - support for \href{https://lottiefiles.com}{lotties} \cr
\item ecStat - statistical tools, see\href{https://github.com/ecomfe/echarts-stat}{echarts-stat}\cr
\item custom - renderers for \link{ecr.band} and \link{ecr.ebars} \cr
}

\strong{Plugins with one-time installation} \cr
\itemize{
\item 3D - support for 3D charts and WebGL acceleration, see \href{https://github.com/ecomfe/echarts-gl}{source} and \href{https://echarts.apache.org/en/option-gl.html#series}{docs} \cr
\verb{     } This plugin is auto-loaded when 3D/GL axes/series are detected.\cr
\item liquid - liquid fill, see \href{https://github.com/ecomfe/echarts-liquidfill}{source}  \cr
\item gmodular - graph modularity, see \href{https://github.com/ecomfe/echarts-graph-modularity}{source}  \cr
\item wordcloud - cloud of words, see \href{https://github.com/ecomfe/echarts-wordcloud}{source} \cr
or install your own third-party plugins.\cr
}

\strong{Crosstalk} \cr
Parameter \emph{df} should be of type \link[crosstalk]{SharedData}, see \href{https://helgasoft.github.io/echarty/articles/gallery.html#crosstalk-2d}{more info}.\cr
Optional parameter \emph{xtKey}: unique ID column name of data frame \emph{df}. Must be same as \emph{key} parameter used in \emph{SharedData$new()}. If missing, a new column \emph{XkeyX} will be appended to df.\cr
Enabling \emph{crosstalk} will also generate an additional dataset called \emph{Xtalk} and bind the \strong{first series} to it.\cr

\strong{Timeline} \cr
Defined by \emph{series.param} for the \href{https://echarts.apache.org/en/option.html#series}{options series} and a \emph{timeline} list for the \href{https://echarts.apache.org/en/option.html#timeline}{actual control}.
A grouped \emph{df} is required, each group providing data for one option serie.
Timeline \href{https://echarts.apache.org/en/option.html#timeline.data}{data} and \href{https://echarts.apache.org/en/option.html#options}{options} will be preset for the chart.\cr
Each option title can include the current timeline item by adding a placeholder '\%@' in title$text. See example below.\cr
Another preset is \emph{encode(x=1,y=2,z=3)}, which are the first 3 columns of \emph{df}. Parameter \emph{z} is ignored in 2D. See Details below.\cr
Optional attribute \emph{groupBy}, a \emph{df} column name, can create series groups inside each timeline option.\cr
Options/timeline for hierarchical charts like graph,tree,treemap,sankey have to be built directly, see \href{https://helgasoft.github.io/echarty/uc4.html}{example}.

Optional series attribute \href{https://echarts.apache.org/en/option.html#series-line.encode}{encode} defines which columns to use for the axes, depending on chart type and coordinate system: \cr
\itemize{
\item set \emph{x} and \emph{y} for coordinateSystem \emph{cartesian2d}
\item set \emph{lng} and \emph{lat} for coordinateSystem \emph{geo} and \emph{scatter} series
\item set \emph{value} and \emph{name} for coordinateSystem \emph{geo} and \emph{map} series
\item set \emph{radius} and \emph{angle} for coordinateSystem \emph{polar}
\item set \emph{value} and \emph{itemName} for \emph{pie} chart.
}

There is an advanced usage of \emph{encode} when each series' item needs to be customized.\cr
For example \code{encode= list(itemStyle= list(opacity='opac'))} will create series data where each series item's opacity comes from df column 'opac'.\cr
This binding feature is specific to \emph{echarty} and does not exist in ECharts. See example below.\cr
}
\examples{
 # basic scatter chart from a data.frame using presets
cars |> ec.init()

 # custom inititlization options and theme
myth <- '{"color": ["green"], "backgroundColor": "lemonchiffon"}'
ec.init( cars,
  theme= jsonlite::fromJSON(myth),
  iniOpts= list(renderer= 'svg', width= '222px'),
  toolbox= list(feature= list(saveAsImage= list()))
)
 
 # grouping, tooltips, formatting, events
iris |> dplyr::group_by(Species) |> 
ec.init(        # init with presets
  tooltip= list(show= TRUE),
  series.param= list( 
    symbolSize= ec.clmn('Petal.Width', scale=7),
    tooltip= list(formatter= ec.clmn('Petal.Width: \%@', 'Petal.Width'))
  ),
  on= list(   # events with Javascript handler
    list(event= 'legendselectchanged', handler= ec.clmn("(e) => alert('legend:'+e.name);"))
 )
)

data.frame(n=1:5) |> dplyr::group_by(n) |> ec.init(
  title= list(text= "gauge #\%@"),
  timeline= list(show=TRUE, autoPlay=TRUE),
  series.param= list(type='gauge', max=5)
)

}
