% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{has_names}
\alias{has_names}
\alias{\%has_names\%}
\title{Check whether an object has certain names}
\usage{
has_names(x, which)

x \%has_names\% which
}
\arguments{
\item{x}{object to test}

\item{which}{name}
}
\description{
Check whether an object has certain names
}
\examples{
\dontrun{
library(assertthat)
li <- list(a = 1, b = 2)

assert_that(li \%has_names\% "a")
# TRUE

assert_that(li \%has_names\% "c")
# Error: li is missing 1 name from "c": "c"

assert_that(li \%has_names\% letters)
# Error: li is missing 24 names from letters: "c", "d", "e", ...
}
}
