% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-summary.R
\name{check_date_coverage}
\alias{check_date_coverage}
\title{Check Date Coverage}
\usage{
check_date_coverage(
  date_var,
  start_date,
  end_date,
  by = "month",
  quiet = FALSE
)
}
\arguments{
\item{date_var}{A vector of dates to check.}

\item{start_date}{Character or Date. Start of the expected date range
(format: "YYYY-MM-DD").}

\item{end_date}{Character or Date. End of the expected date range
(format: "YYYY-MM-DD").}

\item{by}{Character. Period granularity: one of \code{"day"}, \code{"week"},
\code{"month"}, \code{"quarter"}, or \code{"year"}. Defaults to \code{"month"}.}

\item{quiet}{Logical. If \code{TRUE}, suppresses printed output. Defaults to
\code{FALSE}.}
}
\value{
An \link[data.table:IDateTime]{IDate} vector of missing periods, returned
invisibly.
}
\description{
Verifies whether a date vector contains data for all periods within a
specified date range. Reports any missing periods.
}
\examples{
library(data.table)
dates <- as.IDate(c("2023-01-15", "2023-02-20", "2023-04-10"))
check_date_coverage(dates, "2023-01-01", "2023-04-30")
check_date_coverage(dates, "2023-01-01", "2023-04-30", by = "quarter")

}
\seealso{
\code{\link[=check_months_coverage]{check_months_coverage()}} for a convenience wrapper with
\code{by = "month"}
}
