% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/component_samplers.R
\name{sampleDSP}
\alias{sampleDSP}
\title{Sample the dynamic shrinkage process parameters}
\usage{
sampleDSP(
  omega,
  evolParams,
  sigma_e = 1,
  loc = NULL,
  prior_dhs_phi = c(10, 2),
  alphaPlusBeta = 1
)
}
\arguments{
\item{omega}{\code{T x p} matrix of evolution errors}

\item{evolParams}{list of parameters to be updated (see Value below)}

\item{sigma_e}{the observation error standard deviation; for (optional) scaling purposes}

\item{loc}{list of the row and column indices to fill in a band-sparse matrix}

\item{prior_dhs_phi}{the parameters of the prior for the log-volatility AR(1) coefficient \code{dhs_phi};
either \code{NULL} for uniform on [-1,1] or a 2-dimensional vector of (shape1, shape2) for a Beta prior
on \code{[(dhs_phi + 1)/2]}}

\item{alphaPlusBeta}{For the symmetric prior kappa ~ Beta(alpha, beta) with alpha=beta,
specify the sum [alpha + beta]}
}
\value{
List of relevant components:
\itemize{
\item the \code{T x p} evolution error standard deviations \code{sigma_wt},
\item the \code{T x p} log-volatility \code{ht}, the \code{p x 1} log-vol unconditional mean(s) \code{dhs_mean},
\item the \code{p x 1} log-vol AR(1) coefficient(s) \code{dhs_phi},
\item the \code{T x p} log-vol innovation standard deviations \code{sigma_eta_t} from the Polya-Gamma priors,
\item the \code{p x 1} initial log-vol SD \code{sigma_eta_0},
\item and the mean of log-vol means \code{dhs_mean0} (relevant when \code{p > 1})
}
}
\description{
Compute one draw for each of the parameters in the dynamic shrinkage process
for the special case in which the shrinkage parameter \code{kappa ~ Beta(alpha, beta)}
with \code{alpha = beta}. The primary example is the dynamic horseshoe process with
\code{alpha = beta = 1/2}.
}
\note{
The priors induced by \code{prior_dhs_phi} all imply a stationary (log-) volatility process.
}
