% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetHelper.R
\name{subsetHelper}
\alias{subsetHelper}
\title{Ensures that the requested subset is not larger than the original object}
\usage{
subsetHelper(dts, data, rs = NULL, cs = NULL)
}
\arguments{
\item{dts}{a list of \code{\link[DSI]{DSConnection-class}} 
objects obtained after login. If the \code{datasources} argument is not specified
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}

\item{data}{a character string specifying the name of the data frame or
the factor vector and the range of the subset.}

\item{rs}{a vector of two integers specifying the indices of the rows de extract.}

\item{cs}{a vector of two integers or one or more characters.}
}
\value{
\code{subsetHelper} returns a message or the class of the object if the 
object has the same class in all studies.
}
\description{
Compares subset and original object sizes and eventually carries out subsetting.
}
\details{
This function is called by the function \code{ds.subset} to ensure that the requested subset
is not larger than the original object.

This function is internal.

Server function called: \code{dimDS}
}
\examples{
\dontrun{

 ## Version 6, for version 5 see the Wiki
  
  # connecting to the Opal servers

  require('DSI')
  require('DSOpal')
  require('dsBaseClient')

  builder <- DSI::newDSLoginBuilder()
  builder$append(server = "study1", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM1", driver = "OpalDriver")
  builder$append(server = "study2", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM2", driver = "OpalDriver")
  builder$append(server = "study3",
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM3", driver = "OpalDriver")
  logindata <- builder$build()
  
  connections <- DSI::datashield.login(logins = logindata, assign = TRUE, symbol = "D")
  
  subsetHelper(dts = connections, 
               data = "D", 
               rs = 1:10, 
               cs = c("D$LAB_TSC","D$LAB_TRIG"))  
                      
  # clear the Datashield R sessions and logout
  datashield.logout(connections)
}

}
\keyword{internal}
