% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.profile.R
\name{autoplot.profile}
\alias{autoplot.profile}
\title{Plot Profile Objects}
\usage{
\method{autoplot}{profile}(
  object,
  ...,
  main = NULL,
  xlab = "Order of Diversity",
  ylab = "Diversity",
  shade_color = "grey75",
  alpha = 0.3,
  lty = 1,
  lwd = 0.5
)
}
\arguments{
\item{object}{An object of class "profile".}

\item{...}{Unused.}

\item{main}{The main title of the plot.}

\item{xlab}{The label of the x-axis.}

\item{ylab}{The label of the y-axis.}

\item{shade_color}{The color of the shaded confidence envelopes.}

\item{alpha}{The opacity of the confidence envelopes, between 0 (transparent) and 1 (opaque).}

\item{lty}{The line type of the curves.}

\item{lwd}{The line width of the curves.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plot objects of class "profile" produced by \link{profile_hill} and other
profile functions.
}
\examples{
# Diversity profile curve
autoplot(profile_hill(mock_3sp_abd))

}
