% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{print.plot_mztia}
\alias{print.plot_mztia}
\title{Print a plot of MZTIA estimation}
\usage{
\method{print}{plot_mztia}(x, ...)
}
\arguments{
\item{x}{An object of class \sQuote{\code{plot_mztia}} returned by the
\code{\link{plot_mztia}()} function.}

\item{...}{Further arguments passed to or from other methods or arguments
that can be passed down to the \code{\link[boot]{plot.boot}()} function.}
}
\value{
The \sQuote{\code{plot_mztia}} object passed to the \code{x}
parameter is returned invisibly.
}
\description{
This is a method for the function \code{print()} for objects of class
\sQuote{\code{plot_mztia}}.
}
\details{
The element \code{Graph} of the \sQuote{\code{plot_mztia}} object
that is returned by the function \code{\link{plot_mztia}()} is an object
of class \sQuote{\code{ggplot}}, generated by the function
\code{\link[ggplot2]{ggplot}()} from the \sQuote{\code{ggplot2}} package.
Thus, the corresponding \code{plot} method is used for plotting. Arguments
to the \code{\link[ggplot2]{ggplot}()} function can be passed via the
\code{...} parameter.
}
\examples{
# Assessment of data by aid of the mztia() function
res1 <- mztia(data = dip1, shape = "wide", tcol = 3:10, grouping = "type",
              reference = "R", cap = FALSE)

# The 'mztia' object can be passed on to the plot_mztia() function. This
# function does not produce any output but returns a 'plot_mztia' object.
\dontrun{
  gg1 <- plot_mztia(res1)
  gg2 <- print(gg1)

  # The print() function returns the 'plot_mztia' object invisibly.
  class(gg1)
  class(gg2)
}
}
\seealso{
\code{\link{mztia}}, \code{\link{plot_mztia}},
\code{\link[ggplot2]{ggplot}()}, \code{\link[utils]{methods}}.
}
