% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mztia.R
\name{plot_mztia}
\alias{plot_mztia}
\title{Graphical representation of the of MZTIA estimation}
\usage{
plot_mztia(x, ...)
}
\arguments{
\item{x}{An object of class \sQuote{\code{mztia}} returned by the
\code{\link{mztia}()} function.}

\item{...}{Additional parameters that can be passed on to the
\code{\link[ggplot2]{ggplot}()} function.}
}
\value{
An object of class \sQuote{\code{plot_mztia}} is returned invisibly,
consisting of the elements of the \sQuote{\code{mztia}} object and an
additional element named \code{Graph}. The element \code{Graph} is a
\sQuote{\code{ggplot}} object returned by calling the
\code{\link[ggplot2]{ggplot}()} function.
}
\description{
The function \code{plot_mztia()} makes a graphical representation of the
estimates done by the \code{mztia()} function.
}
\details{
A graphical representation of the information in the \code{Data}
element of the object that is returned by \code{mztia()} function is made
by aid of the \code{\link[ggplot2]{ggplot}()} function from the
\sQuote{\code{ggplot2}} package and added as new list element to the
\code{mztia} object. Ideally, the data frame provided to the
\code{\link{mztia}()} function allows drawing a time course of the \% drug
release values. If a single time point is available, the tolerance intervals
of the groups specified by the \code{grouping} parameter (e.g., for the
differentiation of batches or formulations of a drug product) are displayed.
}
\examples{
# Analyse the data by aid of the mztia() function.
res1 <- mztia(data = dip1, shape = "wide", tcol = 3:10, grouping = "type",
              reference = "R", cap = FALSE)

# The 'mztia' object can be passed on to the plot_mztia() function. This
# function does not produce any output. It returns a 'plot_mztia' object that
# is essentially an 'mztia' object augmented by a 'ggplot' object.
\dontrun{
  gg1 <- plot_mztia(res1)
  gg1
}

# Since the element gg1$Graph is a 'ggplot' object it can be used for further
# manipulation by aid of 'ggplot2' functions.
\dontrun{
  if (requireNamespace("ggplot2")) {
    library(ggplot2)

    gg1$Graph + labs(title = "Dissolution Data Assessment",
                     x = "Time [min]", y = "Drug Release [\%]")
  }
}

# Use a data frame in long format.
res2 <- mztia(data = dip5, shape = "long", tcol = 3, grouping = "type",
             reference = "reference", response = "weight", cap = FALSE,
             QS = c(5, 15) / 100)

\dontrun{
  gg2 <- plot_mztia(res2)
  gg2

  if (requireNamespace("ggplot2")) {
    library(ggplot2)

    gg2$Graph + labs(title = "Tolerance Intervals",
                     x = NULL, y = "Weight [ounces]")
  }
}
}
\seealso{
\code{\link{mztia}}, \code{\link[ggplot2]{ggplot}}.
}
